#! /bin/sh
#file: test-out-grammars.bat
# verify that o2 works against some lr(0), lr(1), and lalr(1) grammars
#o2=/mnt/c2d0s0/yacco2/bin/o2
# parms: -t -err 
o2=/usr/local/yacco2/bin/o2
tmp=/tmp/o2
if [ ! -e "$tmp" ] 
then
  mkdir $tmp
fi
cd $tmp
prt_pdf=0
delete_files=1
cont=n
ccresult=0

sw1=$1
sw2=$2
sw3=$3
sw4=$4

file_no=$((0))
file_pos=$((1))
cc_lex()
{
  file_name_only="`basename $2`"
  dir_only="`dirname $2`"
  #echo "%%%%%%%%%%%%%%%%target directory $dir_only"
  eval "$o2  $sw1 $sw2 $sw3 $sw4 $1"
  if test $ccresult -eq 1; then
    echo -n "grammar in error: continue y or n: ";
    read cont;
    if test $cont -eq n; then
      echo "Error in grammar exiting";
      exit 1;
    fi
  fi 
  for j in $sw1 $sw2 $sw3 $sw4 
  do
    case $j in
    *p)
      eval "mpost $file_name_only.mp"
      eval "cweave $file_name_only.w"
      eval "pdftex $file_name_only.tex"
      xref="$file_name_only""_idx"
      echo "%%%%%%%%%%%%%%%%% index file: $xref to cweave and pdftex"
      eval "cweave $xref.w"
      eval "pdftex $xref.tex"
      pdftops "$file_name_only.pdf"
      pdftops "$xref"".pdf"
    esac
  done
if test $delete_files -eq 1; then
  for k in `ls * `;
  do
   #echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!Casing on $k"
   case $k in
    *.cpp|*.h) 
      eval "cp $k $dir_only/$k";
      #echo "-----Copying--------> $k to $dir_only/$k"
      eval "rm -f $k" 
;;
    *.fsc) 
      eval "cp $k $dir_only/$k";
      #echo "-------------> Deleting $k"
      eval "rm -f $k" ;;
    *.scn|*.idx|*.log|*.toc)
      #echo "-------------> Deleting $k"
      eval "rm -f $k" 
;;
    Err.w|T.w) # error and terminal documents to be cweave then pdftex printed by xpdf
      #echo "-------------> Deleting $k"
      #eval "rm -f $k" eof
;;
    *.w)
      #echo "-------------> Deleting $k"
      #eval "rm -f $k" 
;;
    *.tex)
      #echo "-------------> Deleting $k"
      eval "rm -f $k" 
;;
    *.mp)
      #echo "-------------> Deleting $k"
      #eval "rm -f $k" 
;;
    *.tex1)
      #echo "-------------> Deleting $k"
      eval "rm -f $k" 
;;
    *.[1-9])
      #echo "-------------> Deleting Mpost diagrams $k"
      ##eval "rm -f $k" 
;;
     *.[1-9][0-9]*)
      #echo "-------------> Deleting Mpost diagrams $k"
      ##eval "rm -f $k"
 ;;
   esac
  done
fi
}

for i in `find /usr/local/yacco2/grammar-testsuite | grep '.*\.lex$'`;
do
  echo "==========> Test Grammar to compile: $i" 
  file_no=$((++file_no))
  if test $((file_no)) -ge $((file_pos)); then
    file_no_ext=${i%%.*}
    cc_lex $i $file_no_ext
  fi 
done

echo "==========> Run testout program against some data files" 
cd /usr/local/yacco2/grammar-testsuite
./testout testout_1.dat
./testout testout_2.dat
./testout testout_3.dat
./testout xxxx