/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  fsm_phrase_th.lex
Dates:		  11 Mar 2004
Purpose:	  parse fsm phrase
Output:       fsm-phrase
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |fsm_phrase_th| Thread.\fbreak
Parse fsm phrase along with its directives.\fbreak
\fbreak
Example of a fsm construct to parse:\fbreak
\listing{"/usr/local/yacco2/diagrams+etc/fsm.txt"}

@/
fsm	
(fsm-id "fsm_phrase_th.lex",fsm-filename fsm_phrase_th,fsm-namespace NS_fsm_phrase_th
,fsm-class Cfsm_phrase_th{
  user-prefix-declaration
#include "lint_balls.h"
#include "identifier.h"
#include "c_string.h"
#include "fsm_class_phrase_th.h"
#include "o2_externs.h"
  ***
  user-declaration
    public:
    T_fsm_phrase* fsm_phrase_;
  ***
  constructor
    fsm_phrase_ = 0;
  ***
  op
    if(fsm_phrase_ != 0){
      delete fsm_phrase_;
      fsm_phrase_ = 0;
    }
    fsm_phrase_ = new T_fsm_phrase;
    fsm_phrase_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
    AST* t = new AST(*fsm_phrase_);
    fsm_phrase_->phrase_tree(t);
    if(CWEB_MARKER != 0){
      fsm_phrase_->add_cweb_marker(CWEB_MARKER);
      CWEB_MARKER = 0;
    }
  ***
}
,fsm-version "1.0",fsm-date "11 mar 2004",fsm-debug "false"
,fsm-comments "Parse grammar's fsm phrase along with its directives.")
parallel-parser	
(	
  parallel-thread-function
    TH_fsm_phrase_th
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"
rules{
Rfsm_phrase  (){
  -> Rlint_epi
     Ropen_par 
       Rparameters  
     Rclose_par 
     Rlint  {
    op
      Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->fsm_phrase_);
      fsm->fsm_phrase_ = 0;
    ***
    }	
}

Ropen_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "("
}

Rclose_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ")"
}

Rparameters  (){
  -> Rlint
     Rfsm_id_phrase Rlint
     Rfsm_filename_phrase Rlint
     Rfsm_namespace_phrase Rlint
     Rfsm_class_phrase Rlint
     Rfsm_version_phrase Rlint
     Rfsm_date_phrase Rlint
     Rfsm_debug_phrase Rlint
     Rfsm_comments_phrase Rlint
}

Rfsm_id_phrase  (){
  -> Rfsm_id Rlint Rfsm_id_name
}

Rfsm_id  (){
  ->  ||| "#fsm-id" NS_identifier::TH_identifier 
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_id_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
       RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
       RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_id_name  (){
  ->  ||| "c-string" NS_c_string::TH_c_string {
      op
        Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->fsm_phrase_->fsm_id(sf->p2__);
      ***
      }  
  ->  ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_id_string;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_filename_phrase  (){
  -> "," Rlint Rfsm_filename Rlint Rfsm_filename_name
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
       RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_filename  (){
  ->  ||| "#fsm-filename" NS_identifier::TH_identifier 
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_filename_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_filename_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_filename_name  (){
  ->  ||| identifier NS_identifier::TH_identifier {
  /@
Determine if file name properly formed as the
filename witout the extension
is used in generating the emitted files and
the header guard signal.
  @/
      op
        Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->fsm_phrase_->filename_id(sf->p2__);
      ***
      } 
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_filename_id_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_filename_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_namespace_phrase  (){
  -> "," Rlint Rfsm_namespace Rlint Rfsm_namespace_name 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_namespace  (){
  ->  ||| "#fsm-namespace" NS_identifier::TH_identifier 
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_namespace_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_namespace_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_namespace_name  (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op
        Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->fsm_phrase_->namespace_id(sf->p2__);
      ***
      } 
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_namespace_id_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_namespace_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_class_phrase  (){
  -> "," Rlint Rfsm_class Rlint Rfsm_class_name
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_class  (){
  ->  ||| "#fsm-class" NS_identifier::TH_identifier
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_class_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_class_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_class_name  (){
  ->  ||| "fsm-class-phrase" NS_fsm_class_phrase_th::TH_fsm_class_phrase_th {
      op
        Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->fsm_phrase_->fsm_class_phrase(sf->p2__);
      ***
      } 
  ->  ||| |?| NULL {// catcher of what?
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_version_phrase  (){
  -> "," Rlint Rfsm_version Rlint Rfsm_version_string
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_version  (){
  ->  ||| "#fsm-version" NS_identifier::TH_identifier
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_version_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_version_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_version_string  (){
  ->  ||| "c-string" NS_c_string::TH_c_string {
      op
        Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->fsm_phrase_->version(sf->p2__);
      ***
      }  
  ->  ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_version_string;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_date_phrase  (){
  -> "," Rlint Rfsm_date Rlint Rfsm_date_string 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_date  (){
  ->  ||| "#fsm-date" NS_identifier::TH_identifier 
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_date_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_date_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_date_string  (){
  ->  ||| "c-string" NS_c_string::TH_c_string {
      op
        Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->fsm_phrase_->date(sf->p2__);
      ***
      }  
  ->  ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_date_string;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_debug_phrase  (){
  -> "," Rlint Rfsm_debug Rlint Rfsm_debug_string 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_debug  (){
  ->  ||| "#fsm-debug" NS_identifier::TH_identifier
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_debug_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_debug_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_debug_string  (){
  ->  ||| "c-string" NS_c_string::TH_c_string {
      op
        Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
        std::string x(sf->p2__->c_string()->c_str());
        std::string t("true");
        if(x == t){
          fsm->fsm_phrase_->debug(sf->p2__);
          return;
        }
        std::string f("false");
        if(x == f){
          fsm->fsm_phrase_->debug(sf->p2__);
          return;
        }
        CAbs_lr1_sym* sym = new Err_fsm_debug_string_not_true_or_false;
		sym->set_rc(*sf->p2__,__FILE__,__LINE__);
		RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }  
  ->  ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_debug_string;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_comments_phrase  (){
  -> "," Rlint Rfsm_comments Rlint Rfsm_comments_string
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_comma_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_comments  (){
  ->  ||| "#fsm-comments" NS_identifier::TH_identifier
  ->  ||| |?| NULL {
    op
       sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_fsm_comments_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
    ***
    }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_comments_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rfsm_comments_string  (){
  ->  ||| "c-string" NS_c_string::TH_c_string {
      op
        Cfsm_phrase_th* fsm = (Cfsm_phrase_th*)rule_info__.parser__->fsm_tbl__;
        fsm->fsm_phrase_->comment(sf->p2__);
      ***
      }  
  ->  ||| |?| NULL {
      op
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_fsm_comments_string;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}
Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  ->  // force reduce and let other rules determine possible error
}
Rlint_epi  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  ->  // make sure thread's first set sees (
}
}// end of rules
