---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, pages, numérotation des pages, nombre de pages
---

# Comment obtenir la numérotation "page ⟨K⟩ sur ⟨N⟩" ?

Il faut ici procéder en deux étapes.


## Obtenir le nombre de pages d'un document

Ce sujet est traité dans la question 
"[](/3_composition/document/document_metadonnee/combien_de_pages_a_mon_document)".


## Modifier le format de numérotation des pages

La [documentation](texdoc:fancyhdr) de l'extension <ctanpkg:fancyhdr> explique 
comment tirer parti de ce nombre de pages. En voici un exemple :

```
\documentclass[french]{book}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{lastpage}       % Récupération du numéro de la dernière page
  \usepackage{fancyhdr}       % En-têtes et pieds de page personnalisés
  \usepackage{lipsum}         % Du faux texte

  % Redéfinition du style des en-têtes et pieds de page par défaut
  \fancyhf{}
  \renewcommand{\headrulewidth}{0pt}
  \renewcommand{\footrulewidth}{0pt}
  \fancyhead[L,R]{}
  \fancyfoot[C]{\thepage\ / \pageref{LastPage}}

  \fancypagestyle{plain}{% Pour corriger les pages en style plain
    \fancyhead{}\renewcommand{\headrule}{}%
  }

\begin{document}
\pagestyle{fancy}
\chapter{Un classique incontournable}
\lipsum[1-12] % Le faux texte
\end{document}
```

:::{sources}
[Page numbering ⟨n⟩ of ⟨m⟩](faquk:FAQ-nofm)
:::