%% mPICm14.m
%% quartic curve for mathsPIC manual
\documentclass[a4paper]{article}
\usepackage{pictexwd}
\begin{document}
%-----------------
\beginpicture
\linethickness=1pt  %% make a thick line for the axes
paper{units(3cm,cm),xrange(-1,2),yrange(-2,4),axes(XY),ticks(1,1)}
\linethickness=0.4pt       %% reset to default value
\headingtoplotskip=8mm
\plotheading{\fbox{\Large A quartic equation}}
inputfile*(mpicm14.dat)  % inputting file containing data points for curve
variable(r){0.3}       % define a line-free radius r=0.3 for points
point(E1){1,3.5}[,r]
text($f(x)=6x^4 - 8x^3 + 1$){E1}  % center the equation at E1
point(E2){1.4,2}[,r]
drawarrow(E1E2)
point(J1){0.55,2}[,r]
text(inflection points){J1}  % center inflection text at J1
point(J2){0,1}[,r]
point(J3){0.6,0}[,r]
drawarrows(J1J2,J1J3)
\endpicture
%-----------------
\end{document}

