/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXBoolean;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.glossaries.Category;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.Glossary;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsCatLabel;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsLabel;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsType;
import com.dickimawbooks.texparserlib.primitives.IfFalse;
import com.dickimawbooks.texparserlib.primitives.IfTrue;
import com.dickimawbooks.texparserlib.primitives.NewIf;
import java.io.IOException;
import java.util.Vector;

public class GlossaryEntry {
    private String label;
    private int level = 0;
    private GlossariesSty sty;
    private Vector<String> fields;

    public GlossaryEntry(GlossariesSty glossariesSty, String string, KeyValList keyValList, TeXObjectList teXObjectList) throws IOException {
        this.label = string;
        this.sty = glossariesSty;
        this.fields = new Vector();
        TeXParser teXParser = glossariesSty.getParser();
        if (teXParser.isDebugMode(8)) {
            teXParser.logMessage("Defining GlossaryEntry " + string);
        }
        for (String string2 : keyValList.keySet()) {
            TeXObject teXObject = keyValList.getValue(string2);
            if (glossariesSty.isFieldExpansionOn(string2)) {
                if (teXParser.isDebugMode(8)) {
                    teXParser.logMessage("FIELD " + string2 + " expansion on -> " + teXObject.toString(teXParser));
                }
                teXObject = teXParser.expandfully(teXObject, teXObjectList);
            }
            if (teXParser.isDebugMode(8)) {
                teXParser.logMessage("FIELD " + string2 + " -> " + teXObject.toString(teXParser));
            }
            this.setField(string2, teXObject, teXObjectList);
        }
        NewIf.createConditional(false, teXParser, "ifglo@" + string + "@flag");
        glossariesSty.addDefaultFieldValues(this, teXObjectList);
    }

    public void setField(String string, TeXObject teXObject, TeXObjectList teXObjectList) throws IOException {
        this.setField(string, teXObject, true, teXObjectList);
    }

    public void setField(String string, TeXObject teXObject, boolean bl, TeXObjectList teXObjectList) throws IOException {
        String string2;
        Object object;
        ControlSequence controlSequence = null;
        if (string.equals("type")) {
            object = null;
            if (teXObject instanceof GlsType) {
                string2 = ((GlsType)teXObject).getLabel();
                object = ((GlsType)teXObject).getGlossary();
            } else {
                TeXObject teXObject2 = (TeXObject)teXObject.clone();
                string2 = this.sty.getParser().expandToString(teXObject2, teXObjectList);
            }
            if (object == null) {
                object = this.sty.getGlossary(string2);
            }
            teXObject = new GlsType("glo@" + this.getLabel() + "@type", string2, (Glossary)object);
            controlSequence = (GlsType)teXObject;
        } else if (string.equals("category")) {
            object = null;
            if (teXObject instanceof GlsCatLabel) {
                string2 = ((GlsCatLabel)teXObject).getLabel();
                object = ((GlsCatLabel)teXObject).getCategory();
            } else if (teXObject instanceof TextualContentCommand) {
                string2 = ((TextualContentCommand)teXObject).getText();
            } else {
                TeXObject teXObject3 = (TeXObject)teXObject.clone();
                string2 = this.sty.getParser().expandToString(teXObject3, teXObjectList);
            }
            if (object == null) {
                object = this.sty.getCategory(string2);
            }
            teXObject = new GlsCatLabel("glo@" + this.getLabel() + "@category", string2, (Category)object);
            controlSequence = (GlsCatLabel)teXObject;
        } else if (string.equals("parent")) {
            if (teXObject == null || teXObject.isEmpty()) {
                this.level = 0;
                teXObject = null;
            } else {
                object = null;
                if (teXObject instanceof GlsLabel) {
                    string2 = ((GlsLabel)teXObject).getLabel();
                    object = ((GlsLabel)teXObject).getEntry();
                } else {
                    TeXObject teXObject4 = (TeXObject)teXObject.clone();
                    string2 = this.sty.getParser().expandToString(teXObject4, teXObjectList);
                }
                if (object == null && !string2.isEmpty()) {
                    object = this.sty.getEntry(string2);
                }
                if (object == null) {
                    this.level = 0;
                    teXObject = null;
                } else {
                    this.level = ((GlossaryEntry)object).getLevel() + 1;
                    teXObject = new GlsLabel("glo@" + this.getLabel() + "@parent", string2, (GlossaryEntry)object);
                    controlSequence = (GlsLabel)teXObject;
                }
            }
        }
        if (teXObject == null) {
            this.fields.remove(string);
            if (controlSequence == null) {
                object = this.sty.getInternalFieldName(string);
                string2 = String.format("glo@%s@%s", this.getLabel(), object);
            } else {
                string2 = controlSequence.getName();
            }
            this.sty.getParser().removeControlSequence(bl, string2);
        } else {
            if (!this.fields.contains(string)) {
                this.fields.add(string);
            }
            if (controlSequence == null) {
                string2 = this.sty.getInternalFieldName(string);
                object = String.format("glo@%s@%s", this.getLabel(), string2);
                controlSequence = new GenericCommand(true, (String)object, null, teXObject);
            }
            this.sty.getParser().putControlSequence(bl, controlSequence);
        }
    }

    public void remove(String string) {
        this.remove(string, true);
    }

    public void remove(String string, boolean bl) {
        String string2 = this.sty.getInternalFieldName(string);
        String string3 = String.format("glo@%s@%s", this.getLabel(), string2);
        this.fields.remove(string);
        this.sty.getParser().removeControlSequence(bl, string3);
    }

    public boolean hasField(String string) {
        return this.fields.contains(string);
    }

    public boolean isSet(String string) {
        String string2 = this.sty.getInternalFieldName(string);
        String string3 = String.format("glo@%s@%s", this.getLabel(), string2);
        ControlSequence controlSequence = this.sty.getParser().getControlSequence(string3);
        return controlSequence != null;
    }

    public boolean isFieldEmpty(String string) {
        String string2 = this.sty.getInternalFieldName(string);
        String string3 = String.format("glo@%s@%s", this.getLabel(), string2);
        ControlSequence controlSequence = this.sty.getParser().getControlSequence(string3);
        if (controlSequence == null) {
            return true;
        }
        return controlSequence.isEmpty();
    }

    public TeXObject get(String string) {
        String string2 = this.sty.getInternalFieldName(string);
        String string3 = String.format("glo@%s@%s", this.getLabel(), string2);
        ControlSequence controlSequence = this.sty.getParser().getControlSequence(string3);
        if (controlSequence == null) {
            return null;
        }
        if (!this.fields.contains(string)) {
            this.fields.add(string);
        }
        if (controlSequence instanceof GenericCommand) {
            return (TeXObject)((GenericCommand)controlSequence).getDefinition().clone();
        }
        return controlSequence;
    }

    public int getInt(String string, TeXParser teXParser) {
        String string2 = this.sty.getInternalFieldName(string);
        String string3 = String.format("glo@%s@%s", this.getLabel(), string2);
        ControlSequence controlSequence = this.sty.getParser().getControlSequence(string3);
        if (controlSequence == null) {
            return 0;
        }
        if (!this.fields.contains(string)) {
            this.fields.add(string);
        }
        if (!this.fields.contains(string)) {
            this.fields.add(string);
        }
        if (controlSequence instanceof TeXNumber) {
            return ((TeXNumber)((Object)controlSequence)).getValue();
        }
        if (controlSequence instanceof GenericCommand) {
            String string4 = ((GenericCommand)controlSequence).getDefinition().toString(teXParser);
            try {
                int n = Integer.parseInt(string4);
                teXParser.putControlSequence(true, new IntegerContentCommand(string3, n));
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getLevel() {
        return this.level;
    }

    public String getCategory() {
        TeXObject teXObject = this.get("category");
        if (teXObject instanceof TeXObjectList && ((TeXObjectList)teXObject).size() == 1) {
            teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
        }
        if (teXObject != null && teXObject instanceof TextualContentCommand) {
            return ((TextualContentCommand)teXObject).getText();
        }
        return "general";
    }

    public String getType() {
        TeXObject teXObject = this.get("type");
        if (teXObject instanceof TeXObjectList && ((TeXObjectList)teXObject).size() == 1) {
            teXObject = (TeXObject)((TeXObjectList)teXObject).firstElement();
        }
        if (teXObject != null && teXObject instanceof TextualContentCommand) {
            return ((TextualContentCommand)teXObject).getText();
        }
        return "main";
    }

    public Glossary getGlossary(TeXObjectList teXObjectList) throws IOException {
        Vector vector;
        String string;
        Cloneable cloneable = this.get("type");
        if (cloneable instanceof GlsType) {
            Glossary glossary = ((GlsType)cloneable).getGlossary();
            if (glossary == null) {
                ((GlsType)cloneable).refresh(this.sty);
                glossary = ((GlsType)cloneable).getGlossary();
                if (glossary == null) {
                    throw new LaTeXSyntaxException(this.sty.getParser(), "glossaries.glossary.not.defined", ((GlsType)cloneable).getLabel());
                }
            }
            return glossary;
        }
        if (cloneable == null) {
            cloneable = this.sty.getParser().getListener().getControlSequence("glsdefaulttype");
        }
        if (cloneable instanceof TextualContentCommand) {
            string = ((TextualContentCommand)cloneable).getText();
        } else {
            if (cloneable instanceof Expandable && (vector = ((Expandable)((Object)cloneable)).expandfully(this.sty.getParser())) != null) {
                cloneable = vector;
            }
            string = cloneable.toString(this.sty.getParser());
        }
        vector = this.sty.getGlossary(string);
        if (vector == null) {
            throw new LaTeXSyntaxException(this.sty.getParser(), "glossaries.glossary.not.defined", string);
        }
        GlsType glsType = new GlsType("@@glstype", string, (Glossary)vector);
        this.setField("type", glsType, teXObjectList);
        return vector;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean hasParent() {
        TeXObject teXObject = this.get("parent");
        return teXObject != null && !teXObject.isEmpty();
    }

    public GlossaryEntry getParent(TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = this.get("parent");
        if (teXObject == null || teXObject.isEmpty()) {
            return null;
        }
        if (teXObject instanceof GlsLabel) {
            GlossaryEntry glossaryEntry = ((GlsLabel)teXObject).getEntry();
            if (glossaryEntry == null) {
                ((GlsLabel)teXObject).refresh(this.sty);
                glossaryEntry = ((GlsLabel)teXObject).getEntry();
                if (glossaryEntry == null) {
                    this.remove("parent");
                    this.level = 0;
                    throw new LaTeXSyntaxException(this.sty.getParser(), "glossaries.entry.not.defined", ((GlsLabel)teXObject).getLabel());
                }
                this.level = glossaryEntry.getLevel() + 1;
            }
            return glossaryEntry;
        }
        String string = this.sty.getParser().expandToString(teXObject, teXObjectList);
        GlossaryEntry glossaryEntry = this.sty.getEntry(string);
        if (glossaryEntry == null) {
            this.remove("parent");
            this.level = 0;
            throw new LaTeXSyntaxException(this.sty.getParser(), "glossaries.entry.not.defined", string);
        }
        this.level = glossaryEntry.getLevel() + 1;
        this.setField("parent", new GlsLabel("@@parent@label", glossaryEntry.getLabel(), glossaryEntry), teXObjectList);
        return glossaryEntry;
    }

    public void unset(boolean bl) {
        TeXParser teXParser = this.sty.getParser();
        teXParser.putControlSequence(bl, new IfTrue("ifglo@" + this.label + "@flag"));
    }

    public void reset(boolean bl) {
        TeXParser teXParser = this.sty.getParser();
        teXParser.putControlSequence(bl, new IfFalse("ifglo@" + this.label + "@flag"));
    }

    public boolean isUnset() {
        TeXParser teXParser = this.sty.getParser();
        ControlSequence controlSequence = teXParser.getControlSequence("ifglo@" + this.label + "@flag");
        return controlSequence instanceof TeXBoolean && ((TeXBoolean)((Object)controlSequence)).booleanValue();
    }

    public String toString() {
        return String.format("%s[label=%s,level=%d]", this.getClass().getSimpleName(), this.label, this.level);
    }

    public String toString(TeXParser teXParser) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%s[label=%s,level=%d", this.getClass().getSimpleName(), this.label, this.level));
        for (String string : this.fields) {
            String string2 = this.sty.getInternalFieldName(string);
            String string3 = String.format("glo@%s@%s", this.getLabel(), string2);
            ControlSequence controlSequence = this.sty.getParser().getControlSequence(string3);
            String string4 = "";
            if (controlSequence != null) {
                string4 = controlSequence instanceof TextualContentCommand ? ((TextualContentCommand)controlSequence).getText() : (controlSequence instanceof GenericCommand ? ((GenericCommand)controlSequence).getDefinition().toString(teXParser) : controlSequence.toString(teXParser));
            }
            stringBuilder.append(String.format(",%n%s={%s}", string, string4));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

