/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import java.util.Vector;
import nts.command.Command;
import nts.command.CommandBase;
import nts.command.Token;
import nts.io.CharCode;
import nts.typo.TypoAssignPrim;
import nts.typo.TypoCommand;

public class HyphenationPrim
extends TypoAssignPrim {
    protected void assign(Token src, boolean glob) {
        CommandBase.scanLeftBrace();
        StringBuffer buf = new StringBuffer();
        Vector<Integer> hyphBuf = new Vector<Integer>();
        int index = 0;
        while (true) {
            Token tok;
            Command cmd;
            CharCode code;
            if ((code = (cmd = CommandBase.meaningOf(tok = CommandBase.nextExpToken())).charCodeToAdd()) != null) {
                if (code.match('-')) {
                    hyphBuf.add(new Integer(index));
                    continue;
                }
                char letter = code.toCanonicalLetter();
                if (letter != '\uffff') {
                    buf.append(letter);
                    ++index;
                    continue;
                }
                CommandBase.error("NonLetterInHyph");
                continue;
            }
            if (cmd.isSpacer() || cmd.isRightBrace()) {
                if (index > 1) {
                    int[] positions = new int[hyphBuf.size()];
                    int i = 0;
                    while (i < positions.length) {
                        positions[i] = (Integer)hyphBuf.get(i);
                        ++i;
                    }
                    TypoCommand.getTypoConfig().getLanguage().setHyphException(buf.toString(), positions);
                    index = 0;
                    buf.setLength(0);
                    hyphBuf.clear();
                }
                if (!cmd.isRightBrace()) continue;
                break;
            }
            CommandBase.error("ImproperHyphen", this);
        }
    }

    public HyphenationPrim(String name) {
        super(name);
    }
}

