/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import nts.base.Dimen;
import nts.io.CntxLog;
import nts.io.Log;
import nts.noad.Converter;
import nts.noad.Delimiter;
import nts.noad.Egg;
import nts.noad.Field;
import nts.noad.PureNoad;
import nts.noad.StSimpleNodeEgg;
import nts.node.BoxSizes;
import nts.node.GlueSetting;
import nts.node.HBoxNode;
import nts.node.IntVKernNode;
import nts.node.Node;
import nts.node.NodeList;
import nts.node.VBoxNode;

public class FractionNoad
extends PureNoad {
    public static final FractionNoad NULL;
    protected final Field numerator;
    protected final Field denominator;
    protected final Dimen thickness;

    public Field getNumerator() {
        return this.numerator;
    }

    public Field getDenominator() {
        return this.denominator;
    }

    public Dimen getThickness() {
        return this.thickness;
    }

    public FractionNoad numerated(Field numerator) {
        return new FractionNoad(numerator, this.denominator, this.thickness);
    }

    public FractionNoad denominated(Field denominator) {
        return new FractionNoad(this.numerator, denominator, this.thickness);
    }

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc(this.getDesc()).add(", thickness ");
        if (this.thickness == null) {
            log.add("= default");
        } else {
            log.add(this.thickness.toString());
        }
        this.addDelimitersOn(log);
        this.numerator.addOn(log, cntx, '\\');
        this.denominator.addOn(log, cntx, '/');
    }

    public final boolean influencesBin() {
        return true;
    }

    protected String getDesc() {
        return "fraction";
    }

    protected void addDelimitersOn(Log log) {
    }

    public Delimiter getLeftDelimiter() {
        return Delimiter.VOID;
    }

    public Delimiter getRightDelimiter() {
        return Delimiter.VOID;
    }

    protected byte spacingType() {
        return 7;
    }

    public Egg convert(Converter conv) {
        Dimen denShift;
        Dimen numShift;
        Node numNode = this.numerator.cleanBox(conv, (byte)4);
        Node denNode = this.denominator.cleanBox(conv, (byte)5);
        Dimen width = numNode.getWidth().max(denNode.getWidth());
        numNode = numNode.reboxedToWidth(width);
        denNode = denNode.reboxedToWidth(width);
        Dimen middle = conv.getDimPar(16);
        Dimen drt = conv.getDimPar(17);
        Dimen thick = this.thickness != null ? this.thickness : drt;
        boolean display = conv.getStyle() == 0;
        NodeList list = new NodeList(5);
        list.append(numNode);
        if (thick.isZero()) {
            Dimen clr;
            if (display) {
                numShift = conv.getDimPar(2);
                denShift = conv.getDimPar(5);
                Dimen dimen = drt.times(7);
            } else {
                numShift = conv.getDimPar(4);
                denShift = conv.getDimPar(6);
                clr = drt.times(3);
            }
            Dimen delta = clr.minus(numShift.minus(numNode.getDepth()).minus(denNode.getHeight().minus(denShift))).halved();
            if (delta.moreThan(0)) {
                numShift = numShift.plus(delta);
                denShift = denShift.plus(delta);
            }
            list.append(new IntVKernNode(numShift.minus(numNode.getDepth()).minus(denNode.getHeight().minus(denShift))));
        } else {
            Dimen clr;
            if (display) {
                numShift = conv.getDimPar(2);
                denShift = conv.getDimPar(5);
                clr = thick.times(3);
            } else {
                numShift = conv.getDimPar(3);
                denShift = conv.getDimPar(6);
                clr = thick;
            }
            Dimen halfThick = thick.halved();
            Dimen delta = clr.minus(numShift.minus(numNode.getDepth()).minus(middle.plus(halfThick)));
            if (delta.moreThan(0)) {
                numShift = numShift.plus(delta);
            }
            if ((delta = clr.minus(middle.minus(halfThick).minus(denNode.getHeight().minus(denShift)))).moreThan(0)) {
                denShift = denShift.plus(delta);
            }
            list.append(new IntVKernNode(numShift.minus(numNode.getDepth()).minus(middle.plus(halfThick)))).append(PureNoad.makeRule(thick)).append(new IntVKernNode(middle.minus(halfThick).minus(denNode.getHeight().minus(denShift))));
        }
        list.append(denNode);
        VBoxNode fraction = new VBoxNode(new BoxSizes(numNode.getHeight().plus(numShift), width, denNode.getDepth().plus(denShift), numNode.getLeftX().max(denNode.getLeftX())), GlueSetting.NATURAL, list);
        Dimen delSize = display ? conv.getDimPar(14) : conv.getDimPar(15);
        list = new NodeList(3);
        list.append(PureNoad.varDelimiter(this.getLeftDelimiter(), delSize, conv)).append(fraction).append(PureNoad.varDelimiter(this.getRightDelimiter(), delSize, conv));
        return new StSimpleNodeEgg(HBoxNode.packedOf(list), this.spacingType());
    }

    public FractionNoad(Field numerator, Field denominator, Dimen thickness) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.thickness = thickness;
    }
}

