/*
 * Decompiled with CFR 0.152.
 */
package nts.command;

import nts.base.BoolPar;
import nts.command.ContextDisplay;
import nts.command.FilePos;
import nts.command.Token;
import nts.command.TokenizerStack;

public abstract class Tokenizer {
    public static final Tokenizer NULL;
    private TokenizerStack stack = null;
    private Tokenizer next = null;

    public TokenizerStack getStack() {
        return this.stack;
    }

    public Tokenizer getNext() {
        return this.next;
    }

    synchronized void pushTo(TokenizerStack stack, Tokenizer next) {
        if (this.stack != null) {
            throw new RuntimeException("Tokenizer is already in a stack");
        }
        if (this != stack.getTop()) {
            throw new RuntimeException("Misused Tokenizer.pushTo()");
        }
        this.stack = stack;
        this.next = next;
    }

    synchronized void popFrom(TokenizerStack stack) {
        if (this.stack != stack || this.next != stack.getTop()) {
            throw new RuntimeException("Misused Tokenizer.popFrom()");
        }
        this.stack = null;
        this.next = null;
    }

    public abstract Token nextToken(BoolPar var1);

    public boolean close() {
        return false;
    }

    public boolean finishedList() {
        return false;
    }

    public boolean finishedInsert() {
        return false;
    }

    public boolean finished() {
        return this.finishedList();
    }

    public boolean endInput() {
        return false;
    }

    public boolean enoughContext() {
        return false;
    }

    public FilePos filePos() {
        return null;
    }

    public abstract int show(ContextDisplay var1, boolean var2, int var3);
}

