/*
 * Decompiled with CFR 0.152.
 */
package nts.builder;

import nts.base.Dimen;
import nts.base.Glue;
import nts.builder.ListBuilder;
import nts.io.Log;
import nts.node.Box;
import nts.node.BoxLeaders;
import nts.node.BoxSizes;
import nts.node.Leaders;
import nts.node.NamedVSkipNode;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.RuleNode;
import nts.node.VKernNode;
import nts.node.VLeadRuleNode;
import nts.node.VLeadersNode;
import nts.node.VSkipNode;

public abstract class VertBuilder
extends ListBuilder {
    public static final Dimen IGNORE_DEPTH = Dimen.valueOf(-1000);
    private int prevGraf = 0;
    private Dimen prevDepth = IGNORE_DEPTH;

    public boolean isVertical() {
        return true;
    }

    public boolean wantsMigrations() {
        return true;
    }

    public void addKern(Dimen kern) {
        this.addNode(new VKernNode(kern));
    }

    public void addSkip(Glue skip) {
        this.addNode(new VSkipNode(skip));
    }

    public void addNamedSkip(Glue skip, String name) {
        this.addNode(new NamedVSkipNode(skip, name));
    }

    public void addRule(BoxSizes sizes) {
        this.addNode(new RuleNode(sizes));
        this.uncheckedSetPrevDepth(IGNORE_DEPTH);
    }

    public void addLeaders(Glue skip, Leaders lead) {
        this.addNode(new VLeadersNode(skip, lead));
    }

    public void addLeadRule(Glue skip, BoxSizes sizes, String desc) {
        this.addNode(new VLeadRuleNode(skip, sizes, desc));
    }

    public BoxLeaders.Mover getBoxLeadMover() {
        return VLeadersNode.BOX_MOVER;
    }

    public void addBox(Node box) {
        super.addBox(box);
        this.uncheckedSetPrevDepth(box.getDepth());
    }

    protected NodeEnum unBoxList(Box box) {
        return box.getVertList();
    }

    public int getPrevGraf() {
        return this.prevGraf;
    }

    public void setPrevGraf(int pg) {
        this.prevGraf = pg;
    }

    public Dimen getPrevDepth() {
        return this.prevDepth;
    }

    protected void uncheckedSetPrevDepth(Dimen pd) {
        this.prevDepth = pd;
    }

    public Dimen nearestValidPrevDepth() {
        return this.prevDepth;
    }

    public void setPrevDepth(Dimen pd) {
        if (pd != null) {
            this.prevDepth = pd;
        }
    }

    public boolean needsParSkip() {
        return !this.list.isEmpty();
    }

    protected void specialShow(Log log) {
        log.startLine().add("prevdepth ");
        if (this.getPrevDepth().moreThan(IGNORE_DEPTH)) {
            log.add(this.getPrevDepth().toString());
        } else {
            log.add("ignored");
        }
        if (this.prevGraf != 0) {
            log.add(", prevgraf ").add(this.prevGraf).add(this.prevGraf == 1 ? " line" : " lines");
        }
    }

    protected VertBuilder(int line, NodeList list) {
        super(line, list);
    }

    protected VertBuilder(int line) {
        super(line);
    }
}

