/* ftruncat.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __ftruncate(int fd, long length)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    DWORD dwSize;

    if (fd >= N_FILES || fd < 0)
	return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
	return _rsxnt_errno(EBADF);

    dwSize = GetFileSize (p->file[fd].f_handle, NULL);
    if (dwSize == 0xffffffff)
	return _rsxnt_get_last_errno();
    else if (dwSize <= (DWORD)length)
	return 0;

    dwSize = SetFilePointer (p->file[fd].f_handle, length, NULL, FILE_BEGIN);
    if (dwSize == 0xffffffff)
	return _rsxnt_get_last_errno();

    if (SetEndOfFile(p->file[fd].f_handle) == FALSE)
	return _rsxnt_get_last_errno();
    else
	return 0;
}
