# call of the printer driver dvips with the file $main_file, output into $prt_file
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc prt_dvips {f austext} {

  upvar 1 $austext a

  global vv main_file prtoptions pg_start pg_end prmsel prt_file opsep printcops dirprefix
  global prtcmd prtcmdmax Page prmrelabs asuff

  set a ""
  writescr $f "[datime] $vv(dta1) \"[lindex [info level [info level]] 0].tcl\" $vv(dta2)\n"
  TestPut 4 "<$prmsel> <$main_file><$pg_start><$pg_end> <$prtoptions><$opsep><$printcops>"

  if {$dirprefix==""} {set mainfile $main_file} else {set mainfile [fileName $main_file]}
  if {![file exists $mainfile$asuff]&&[file exists $main_file$asuff]} \
		      {set mainfile $main_file}

  set opt1 "[lindex [split $prtoptions $opsep] 1]";# set driver options (except format)
  if {$printcops!="1"} {set opt1 "$opt1 -C $printcops"};# add number of copies to options
  set opt2 "[lindex [split $prtoptions $opsep] 2]";# set format dependent driver options

  set opt_seiten ""  

  if	 {$pg_start!="$vv(dmstart)" }		{set startpage $pg_start} \
  elseif {($prmrelabs=="a")&&($Page(OK)==1)}	{set startpage $Page(afirst)} \
  else						{set startpage 1}

  if { $pg_end=="$vv(dmend)" }     {set endpage 9999} else {set endpage  $pg_end}

  if { $startpage>$endpage } \
      {set opt1 "$opt1 -r*"; set p $endpage; set endpage $startpage; set startpage $p}


  TestPut 4 "<$opt1><$opt2> <$startpage><$endpage>"


  if { $prmsel == "vstcommands" } {# list of commands from setting file prt_*.vst

    TestPut 4 "via vstcommands ($prtcmdmax): <$prtoptions> <$opt1><$opt2>"
    for {set c 1} {($c<=$prtcmdmax)&&($prtcmd($c)!="")} {incr c} {
      TestPut 4 "\tprtcmd($c)=<$prtcmd($c)>"
      set cmd [lindex $prtcmd($c) 0]
      #set opt "[eval list [lrange $prtcmd($c) 1 end]]"; #does not work with dvidvi: "(...)"
      #set opt "[lrange $prtcmd($c) 1 end]"; # does nost work with Tcl8.0: "{ }" generated
      set opt [string trim [string range  $prtcmd($c) [string length $cmd] end]]
      set opt [prtRegsub "$opt" $mainfile "$opt1" "$opt2" "$startpage" "$endpage"]
      eval mkCmd_wait $f $cmd [list "$opt"]
    }

  } elseif { ($prmsel == "rel") || ($prmsel == "abs") } {# von ... bis ... alle Seiten 

    if { $prmsel == "rel" }        { set ar "=" } else { set ar "" }
    if { $pg_start != "$vv(dmstart)" }  { set opt_seiten "$opt_seiten -p $ar$startpage" }
    if { $pg_end != "$vv(dmend)" }     { set opt_seiten "$opt_seiten -l $ar$endpage"  }
    eval mkCmd_wait $f dvips [list "$opt1 $opt2 $opt_seiten -o $prt_file $mainfile"]

  } elseif { ($prmsel == "u_abs") || ($prmsel == "g_abs") } {# nur gerade bzw. ungerade

    if { $pg_start != "$vv(dmstart)" } {
      if { $prmsel == "u_abs" }  { set startpage [expr "(($startpage/2)*2)+1"] }
      if { $prmsel == "g_abs" }  { set startpage [expr "(($startpage+1)/2)*2"] }
      set opt_seiten "$opt_seiten -p $startpage"
    }
    if { $pg_end != "$vv(dmend)" } {
      if { $prmsel == "u_abs" }  {set endpage  [expr "((($endpage+1)/2)*2)-1"]}
      if { $prmsel == "g_abs" }  {set endpage  [expr "($endpage/2)*2"] }
      set opt_seiten "$opt_seiten -l $endpage"
    }
    if { $prmsel == "u_abs" }  {set opt_seiten "$opt_seiten -A"}
    if { $prmsel == "g_abs" }  {set opt_seiten "$opt_seiten -B"}
    if { $startpage>$endpage } {set a "${a} $startpage>$endpage\n\n"; mybell 3; return 1}

    eval mkCmd_wait $f dvips [list "$opt1 $opt2 $opt_seiten -o $prt_file $mainfile"]

  } elseif { ($prmsel == "a5buchvorder") } {

    eval mkCmd_wait $f dvidvi [list "-m \"4:-1,2(148mm,0mm)\" $mainfile.dvi tmp.dvi"]
    eval mkCmd_wait $f dvips  [list "$opt1 $opt2 -t landscape -o $prt_file tmp.dvi"]
    FileDelete tmp.dvi

  } elseif { ($prmsel == "a5buchrueck") } {

    eval mkCmd_wait $f dvidvi [list "-m \"4:-3,0(148mm,0mm)\" $mainfile.dvi tmp.dvi"]
    eval mkCmd_wait $f dvips  [list "$opt1 $opt2 -t landscape -o $prt_file tmp.dvi"]
    FileDelete tmp.dvi

  } elseif { ($prmsel == "verkleinern2") } {

    ### alternatively:

    eval mkCmd_wait $f dvidvi [list "-f $startpage -l $endpage $mainfile.dvi tmp.1.dvi"]
    eval mkCmd_wait $f dvidvi [list "-m \"2:0,1(206mm,0mm)\" tmp.1.dvi tmp.dvi"]
    FileDelete tmp.1.dvi
    eval mkCmd_wait $f dvips  [list "$opt1 $opt2 -x 694 -t landscape -o $prt_file tmp.dvi"]
    FileDelete tmp.dvi

    ### or (e.g. with teTeX):

    # eval mkCmd_wait $f dvired [list "-p $startpage -l $endpage -o $prt_file $mainfile"]

  } elseif { ($prmsel == "us2") } {

    ### alternatively:

    eval mkCmd_wait $f dvidvi [list "-f $startpage -l $endpage $mainfile.dvi tmp.1.dvi"]
    eval mkCmd_wait $f dvidvi \
	[list "-m \"2:0(-0.3611in,0.4028in),1(7.1389in,0.4026in)\" tmp.1.dvi tmp.dvi"]
    FileDelete tmp.1.dvi
    eval mkCmd_wait $f dvips  \
	[list "$opt1 $opt2 -x 720 -t landscape -O -0.28in,-0.28in -o $prt_file tmp.dvi"]
    FileDelete tmp.dvi

  } elseif { ($prmsel == "verkleinern4") } {

    eval mkCmd_wait $f dvidvi [list "-f $startpage -l $endpage $mainfile.dvi tmp.1.dvi"]
    eval mkCmd_wait $f dvidvi [list "-m \
      \"4:0(-25mm,-25mm),1(185mm,-25mm),2(-25mm,267mm),3(185mm,267mm)\" \
      tmp.1.dvi tmp.dvi"]
    FileDelete tmp.1.dvi
    eval mkCmd_wait $f dvips  [list "$opt1 $opt2 -x 500 -o $prt_file tmp.dvi"]
    FileDelete tmp.dvi

  } else {       # error: unexpected value of $prmsel 

    set a "${a}*** $vv(aerr) (prt_dvips.tcl): $vv(dt1) \"$prmsel\"\n"
    set a "${a}    $vv(adm)\n\n"
    mybell 3; return 1
    set opt_seiten "$opt_seiten -p =$startpage"
    set opt_seiten "$opt_seiten -l =$endpage"
    eval mkCmd_wait $f dvips [list "$opt1 $opt2 $opt_seiten -o $prt_file $mainfile"]

  }

  return 0

}
