# "quick&dirty" TeX run and previewing ($main_file$tsuff (preamble only) with $mouse_grab)
#
# Copyright (C) 1994  G. Lamprecht, W. Lotz, R. Weibezahn; LRW c/o Uni Bremen
# Copyright (C) 1996  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University

proc quick {f austext what} {

  upvar 1 $austext a

  global vv pid texmem texfmt main_file tsuff efile esuff preview prsuffix proptions prpreopt
  global quickfile preamble mouse_grab preamble_found quickverbatim quickprereq
  global quickpreamble quickendpre quickenddoc quickdelfile quickmultprv quicknonstop
  global quickprev quickprevstd quickprsstd quickpreform quicksuffix


  writescr0 $f ""
  set a ""

  if {$what=="mouse-grab"} {
    writescr $f "[datime] $vv(qd1)\n$vv(qd2) `$main_file$tsuff' ---> $quickfile$quicksuffix\n"
  } else {
    writescr $f "[datime] $vv(qd3) `$efile$esuff'\n$vv(qd4) ---> $quickfile$quicksuffix\n"
  }

  # look for the preamble
  if {($main_file=="")||(![file exists $main_file$tsuff])} {# main file does'nt exist
    set preamble "$quickpreamble"
  } else {# file exists
    getPreamble $main_file$tsuff
    if {!$preamble_found} {# no preamble identified
      writescr $f "${a}\n$vv(qd9)\n   \"$quickendpre\"\n"
      if {$quickprereq==1} {# preamble requested!
	mybell 4
	writescr $f "$vv(qd10) \"$texfmt\" $vv(qd11)\n"
	writescr $f "$vv(qd12) \"$main_file$tsuff\" $vv(qd13)\n$vv(qd14)\n"
      }
    }
  }

  writescr $f "\n%%%%%%%%%% $vv(qd5) $vv(qd7) %%%%%%%%%%"
  writescr $f "\n$[TopAndTail "$preamble" 4]"
  writescr $f "\n%%%%%%%%%% $vv(qd6) $vv(qd7) %%%%%%%%%%"
  writescr $f "\n$quickendpre";                           # writescr $f "\n\begin{document}"
  if {$what=="mouse-grab"} {
    writescr $f "\n%%%%%%%%%% $vv(qd5) $vv(qd8) %%%%%%%%%%"
    writescr $f "\n[TopAndTail "$mouse_grab" 4]"
    writescr $f "\n%%%%%%%%%% $vv(qd6) $vv(qd8) %%%%%%%%%%"
  } elseif {$what=="efile"} {
    writescr $f "\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
    writescr $f "\n$vv(fs12) $efile$esuff"
    writescr $f "\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"
  }
  writescr $f "\n$quickenddoc\n"

  set quickseptext {\par\bigskip\normalsize\noindent\hrulefill\ generated by: \hrulefill}
  set fd [open $quickfile$quicksuffix w]
  puts $fd "$preamble"
  puts $fd "$quickendpre"
  if {$what=="mouse-grab"} {
    puts $fd "$mouse_grab"
    if {$quickverbatim!=0}			{puts $fd "$quickseptext"}
    if {$quickverbatim==1||$quickverbatim==-1}	{putsVerbatim $fd "$preamble\n$quickendpre"}
    if {$quickverbatim==1||$quickverbatim==-2}	{putsVerbatim $fd "$mouse_grab"}
    if {$quickverbatim==1||$quickverbatim==-1}	{putsVerbatim $fd "$quickenddoc"}
  } elseif {$what=="efile"} {
    puts $fd "\\input\{$efile$esuff\}"
  }
  puts $fd "$quickenddoc"
  close $fd

  if {($what=="efile")||($quicknonstop!=1)} {
    mkCmd_wait $f $quickpreform [list "\\input $quickfile$quicksuffix"]
  } else {
    mkCmd_wait $f $quickpreform [list "\\nonstopmode \\input $quickfile$quicksuffix"]
  }

  quickprevstdCheck; # if necessary, quickprev is set to current_preview
  set dviNewGenerated [mdtest $quickfile $quicksuffix .dvi dummy]

  if {$dviNewGenerated!=1} {# no dvi file created!

    set a "${a}\n\n***** $vv(pr9) $quickfile.dvi $vv(ea4)\n"; mybell 2
    if {$quickdelfile==2} {QuickFilDel --all; # delete all Quick&Dirty files}

  } else {# preview

    writescr $f "[datime] $vv(pr1) $quickfile\n"

    # if postscript preview: refresh postscript file 
    if {("$quickprev"=="current_preview")&&("$prsuffix"==".ps")} {
	set prevfil $quickfile.ps; mkCmd_wait $f dvips "$quickfile.dvi $prpreopt -o $prevfil"
    } elseif {("$quickprev"=="standard_preview")&&("$quickprsstd"==".ps")} {
	set prevfil $quickfile.ps; mkCmd_wait $f dvips "$quickfile.dvi -o $prevfil"
    } else {set prevfil $quickfile.dvi}

    if {($quickmultprv==0)&&([processActive qdliste]!=0)} {# use existing Q&D preview

      set a "${a}\n\n***** $vv(qd30)\n"; mybell 1

    } else {# no Quick&Dirty preview active or more than 1 Quick&Dirty preview allowed

      if {"$quickprev"=="current_preview"}	{set prevcom "$preview $proptions"}	\
      else					{regsub -all "&" "$quickprevstd" "" prevcom} 

      if [file exists "$prevfil"] {
	set a "${a}[datime] $preview $vv(pr7)\n"
	SigChldB; eval set res [catch "exec $prevcom $prevfil &" message]; SigChldU
	set pid $message
	set a "${a}$message\n";  if {$res!=0} {set a "${a}$vv(pr8)=$res\n"}
      }

    }
    if {$quickdelfile==2} {QuickFilDel $prevfil;#delete Quick&Dirty files except preview file}
  }

  return
}
