# xtem version is set here
#
# Copyright (C) 1999  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
###################################################################

set version "7.03"		;# sets xtem version; xtem-Version
set version_incompatible "5.04"	;# sets .vst-file compatibility
set status ""			;# xtem status ("-alpha" | "-beta" | "")
set patches ""			;# xtem applied patches

proc setTclVersions {} {
 global vv tclversion patchlevel tclVersion addinput extended email www
 global NeedsMinimumTclOlderXtem NeedsMinimumTclThisXtem UpgradeRecommendedTclOlder
 global TestedUpToTcl SeemsToBeRunningTcl stt noWarnTcl TclExtend

 set addinput [info command addinput]
 set extended [info command infox]
 set NeedsMinimumTclOlderXtem   7.0;  set XtemRunningWith 4.16
 set NeedsMinimumTclThisXtem    7.6;
 set UpgradeRecommendedTclOlder 7.6;
 set TestedUpToTcl              8.2;
 set SeemsToBeRunningTcl        8.2;
 set tclversion [info tclversion]; set patchlevel [info patchlevel]; # the "real version"
						# tclVersion is the "simulated version"

 if {($tclversion<$NeedsMinimumTclOlderXtem)} {

   # < 7.0:  will never run with this tcl version
   puts stdout \
	"xtem doesn't run with your old Tcl Version ($tclversion), see Installation Guide!"
   exit

 } elseif {($tclversion>=$NeedsMinimumTclOlderXtem)&&($tclversion<$NeedsMinimumTclThisXtem)} {

   puts stdout "This version of xtem presumes Tcl-version >= $NeedsMinimumTclThisXtem"
   puts stdout "yet there exists an older version of xtem running with your"
   puts stdout "Tcl/Tk version ($tclversion), see Installation Guide or README's!"
   exit

 } elseif {$tclversion<$UpgradeRecommendedTclOlder} {# upgrade of Tcl/Tk is recommended

   if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}$vv(xtq5)\n\n"
   }
   set tclVersion $tclversion

 } elseif {$tclversion<=$TestedUpToTcl} {# OK

   ### for {set i 0} {$i<=1} {incr i} {after 100; mybell 3}
   set tclVersion $tclversion

 } elseif {$tclversion<=$SeemsToBeRunningTcl} {# couldn't test it for myself with this Tcl/Tk!

   if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}$vv(xtq21) $tclversion $vv(xtq22)\n$vv(xtq23)\n$vv(xtq24)\n$www\n$email\n"
   }
   set tclVersion $TestedUpToTcl; mybell 1

 } else {#  no information

   if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}*** $vv(xtq21) $tclversion $vv(xtq22)\n$vv(xtq24):\n$www\n$email\n"
     set stt "${stt}\n$vv(xtq25)\n$vv(xtq26)\n  noWarnTcl  $tclversion\n"
   }
   set tclVersion $TestedUpToTcl; mybell 4

 }

 set shell ""
 if {[info commands set]!=""}	{set shell "${shell}Tcl"}
 if {[info commands pack]!=""}	{set shell "${shell}/Tk"}
 if {[info commands infox]!=""}	{set shell "${shell}/TclX"; set TclExtend 1} {set TclExtend 0}
 if {([info procs XiExit]=="XiExit")} {
   return "$shell"
 } elseif {($shell!="Tcl/Tk/TclX")} {
   puts stdout "\n***** Error: Variable WISHCALL in file xteminstall"
   puts stdout "is no `wishx' (*must* include Tcl + Tk + TclX !)"
   puts stdout "(see `Installation Guide' and run xteminstall after correction)\n"
   exit
 }
 
}
