/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.spelling;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.texlipse.PathUtils;
import net.sourceforge.texlipse.SelectedResourceManager;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.properties.TexlipseProperties;
import net.sourceforge.texlipse.spelling.SpellingCompletionProposal;
import net.sourceforge.texlipse.spelling.SpellingMarkerResolution;
import net.sourceforge.texlipse.spelling.SpellingResolutionGenerator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class SpellChecker
implements IPropertyChangeListener {
    public static final String SPELLING_ERROR_MARKER_TYPE = String.valueOf(TexlipseProperties.PACKAGE_NAME) + ".spellingproblem";
    public static final String SPELL_CHECKER_COMMAND = "spellCmd";
    public static final String SPELL_CHECKER_ARGUMENTS = "spellArgs";
    public static final String SPELL_CHECKER_ENV = "spellEnv";
    private static final String ASPELL_ENCODING = "UTF-8";
    public static String SPELL_CHECKER_ADD = "spellCheckerAddToUserDict";
    public static String SPELL_CHECKER_IGNORE = "spellCheckerIgnoreWord";
    private static SpellChecker instance = new SpellChecker();
    private Process spellProgram;
    private PrintWriter output;
    private BufferedReader input;
    private String command;
    private String[] envp;
    private Map<IMarker, String[]> proposalMap = new HashMap<IMarker, String[]>();
    private String language = "en";

    private SpellChecker() {
        SPELL_CHECKER_ADD = TexlipsePlugin.getResourceString(SPELL_CHECKER_ADD);
        SPELL_CHECKER_IGNORE = TexlipsePlugin.getResourceString(SPELL_CHECKER_IGNORE);
    }

    public static void initializeDefaults(IPreferenceStore prefs) {
        String aspell = PathUtils.findEnvFile("aspell", "/usr/bin", "aspell.exe", "C:\\gnu\\aspell");
        prefs.setDefault(SPELL_CHECKER_COMMAND, aspell);
        prefs.setDefault(SPELL_CHECKER_ENV, "");
        prefs.setDefault(SPELL_CHECKER_ARGUMENTS, "-a -t --lang=%language --encoding=%encoding");
        prefs.addPropertyChangeListener((IPropertyChangeListener)instance);
        instance.readSettings();
    }

    public static void addWordToAspell(String word) {
        if (SpellChecker.instance.command == null) {
            instance.readSettings();
        }
        String cmd = SpellChecker.instance.command;
        BuilderRegistry.printToConsole("aspell> adding word: " + word);
        String[] environp = PathUtils.mergeEnvFromPrefs(PathUtils.getEnv(), SPELL_CHECKER_ENV);
        try {
            Process p = Runtime.getRuntime().exec(cmd, environp);
            PrintWriter w = new PrintWriter(new OutputStreamWriter(p.getOutputStream(), ASPELL_ENCODING));
            w.println("*" + word);
            w.println("#");
            w.flush();
            w.close();
            p.getOutputStream().close();
            p.waitFor();
        }
        catch (Exception e) {
            BuilderRegistry.printToConsole("Error adding word \"" + word + "\" to Aspell user dict\n");
            TexlipsePlugin.log("Adding word \"" + word + "\" to Aspell user dict", e);
        }
    }

    private void readSettings() {
        this.command = null;
        this.envp = null;
        String path = TexlipsePlugin.getPreference(SPELL_CHECKER_COMMAND);
        if (path == null || path.length() == 0) {
            return;
        }
        File f = new File(path);
        if (!f.exists() || f.isDirectory()) {
            return;
        }
        String args = TexlipsePlugin.getPreference(SPELL_CHECKER_ARGUMENTS);
        args = args.replaceAll("%encoding", ASPELL_ENCODING);
        args = args.replaceAll("%language", this.language);
        this.command = String.valueOf(f.getAbsolutePath()) + " " + args;
        this.envp = PathUtils.mergeEnvFromPrefs(PathUtils.getEnv(), SPELL_CHECKER_ENV);
    }

    private void checkLanguage(IFile file) {
        String pLang = null;
        IProject prj = file.getProject();
        if (prj != null) {
            pLang = TexlipseProperties.getProjectProperty((IResource)prj, "langSpell");
        }
        boolean restart = false;
        if (pLang != null && pLang.length() > 0 && !pLang.equals(this.language)) {
            this.language = pLang;
            restart = true;
        }
        if (restart) {
            this.stopProgram();
            this.readSettings();
        }
    }

    protected boolean checkProgram(IFile file) {
        this.checkLanguage(file);
        if (this.spellProgram == null) {
            return this.startProgram();
        }
        int exitCode = -1;
        try {
            exitCode = this.spellProgram.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {}
        if (exitCode != -1) {
            this.spellProgram = null;
            return this.startProgram();
        }
        return false;
    }

    private boolean startProgram() {
        String message;
        block10: {
            BuilderRegistry.printToConsole(String.valueOf(TexlipsePlugin.getResourceString("viewerRunning")) + ' ' + this.command);
            try {
                if (this.command == null) {
                    throw new IOException();
                }
                this.spellProgram = Runtime.getRuntime().exec(this.command, this.envp);
            }
            catch (IOException iOException) {
                this.spellProgram = null;
                this.input = null;
                this.output = null;
                BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("spellProgramStartError"));
                return false;
            }
            try {
                this.output = new PrintWriter(new OutputStreamWriter(this.spellProgram.getOutputStream(), ASPELL_ENCODING));
                this.input = new BufferedReader(new InputStreamReader(this.spellProgram.getInputStream(), ASPELL_ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.spellProgram = null;
                this.input = null;
                this.output = null;
                BuilderRegistry.printToConsole("Unsupported encoding");
                return false;
            }
            try {
                message = this.input.readLine();
                if (message != null) break block10;
                BufferedReader error = new BufferedReader(new InputStreamReader(this.spellProgram.getErrorStream()));
                message = error.readLine();
                if (message == null) {
                    BuilderRegistry.printToConsole("Aspell failed! No output could be read.");
                } else {
                    BuilderRegistry.printToConsole("aspell> " + message.trim());
                }
                error.close();
                return false;
            }
            catch (IOException e) {
                TexlipsePlugin.log("Aspell died", e);
                BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("spellProgramStartError"));
                return false;
            }
        }
        BuilderRegistry.printToConsole("aspell> " + message.trim());
        this.output.println("!");
        return true;
    }

    private void stopProgram() {
        if (this.spellProgram != null) {
            this.spellProgram.destroy();
            this.spellProgram = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String prop = event.getProperty();
        if (prop.startsWith("spell")) {
            this.stopProgram();
            this.readSettings();
        }
    }

    public static void checkSpelling(String line, int offset, int lineNumber, IFile file) {
        if (instance.checkProgram(file)) {
            instance.checkLineSpelling(line, offset, lineNumber, file);
        }
    }

    public static void checkSpelling(IDocument document, IFile file) {
        instance.startSpellCheck(document, file);
    }

    private void startSpellCheck(IDocument document, IFile file) {
        SpellCheckJob job = new SpellCheckJob("Spellchecker", document, file);
        job.setUser(true);
        job.schedule();
    }

    private static void checkSpellingDirectly(IDocument document, IFile file, IProgressMonitor monitor) {
        if (instance.checkProgram(file)) {
            instance.checkDocumentSpelling(document, file, monitor);
        }
    }

    private void checkDocumentSpelling(IDocument doc, IFile file, IProgressMonitor monitor) {
        this.deleteOldProposals((IResource)file);
        try {
            int num = doc.getNumberOfLines();
            monitor.beginTask("Check spelling", num);
            int i = 0;
            while (i < num) {
                if (!monitor.isCanceled()) {
                    int offset = doc.getLineOffset(i);
                    int length = doc.getLineLength(i);
                    String line = doc.get(offset, length);
                    this.checkLineSpelling(line, offset, i + 1, file);
                    monitor.worked(1);
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            TexlipsePlugin.log("Checking spelling on a line", e);
        }
        this.stopProgram();
    }

    /*
     * Unable to fully structure code
     */
    private static String replaceUmlauts(String line) {
        out = new StringBuilder();
        addWS = 0;
        i = 0;
        while (i < line.length()) {
            c = line.charAt(i);
            if (addWS > 0 && Character.isWhitespace(c)) {
                j = 0;
                while (j < addWS) {
                    out.append(' ');
                    ++j;
                }
                addWS = 0;
            }
            if (c != '\\') ** GOTO lbl-1000
            if (i + 2 < line.length() && line.charAt(i + 1) == 's' && line.charAt(i + 2) == 's' && (i + 3 == line.length() || Character.isWhitespace(line.charAt(i + 3)) || line.charAt(i + 3) == '\\' || line.charAt(i + 3) == '}')) {
                out.append('\u00df');
                i += 2;
                addWS = 2;
            } else if (i + 1 < line.length() && line.charAt(i + 1) == '\"' && i + 2 < line.length()) {
                c2 = line.charAt(i + 2);
                i += 2;
                addWS = 2;
                switch (c2) {
                    case 'a': {
                        out.append('\u00e4');
                        break;
                    }
                    case 'u': {
                        out.append('\u00fc');
                        break;
                    }
                    case 'o': {
                        out.append('\u00f6');
                        break;
                    }
                    case 'A': {
                        out.append('\u00c4');
                        break;
                    }
                    case 'U': {
                        out.append('\u00dc');
                        break;
                    }
                    case 'O': {
                        out.append('\u00d6');
                        break;
                    }
                    default: {
                        i -= 2;
                        addWS = 0;
                        out.append('\\');
                        break;
                    }
                }
            } else lbl-1000:
            // 2 sources

            {
                out.append(c);
            }
            ++i;
        }
        return out.toString();
    }

    private void checkLineSpelling(String line, int offset, int lineNumber, IFile file) {
        if (line == null || line.length() == 0) {
            return;
        }
        if (line.trim().length() == 0) {
            return;
        }
        String lineToPost = line;
        if (this.language.equals("de")) {
            lineToPost = SpellChecker.replaceUmlauts(line);
        }
        this.output.println("^" + lineToPost);
        this.output.flush();
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String result = this.input.readLine();
            while (!"".equals(result) && result != null) {
                lines.add(result);
                result = this.input.readLine();
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
            while (this.input.ready()) {
                this.input.readLine();
            }
        }
        catch (IOException e) {
            BuilderRegistry.printToConsole(TexlipsePlugin.getResourceString("spellProgramStartError"));
            TexlipsePlugin.log("aspell error at line " + lineNumber + ": " + lineToPost, e);
        }
        int i = 0;
        while (i < lines.size()) {
            String[] options;
            String[] tmp = ((String)lines.get(i)).split(":");
            String[] error = tmp[0].split(" ");
            String word = error[1].trim();
            int column = Integer.valueOf(error[error.length - 1]) - 1;
            if (tmp.length > 1) {
                String[] proposals = tmp[1].trim().split(", ");
                options = new String[proposals.length + 2];
                int j = 0;
                while (j < proposals.length) {
                    options[j] = proposals[j].trim();
                    ++j;
                }
            } else {
                options = new String[2];
            }
            options[options.length - 2] = MessageFormat.format(SPELL_CHECKER_IGNORE, word);
            options[options.length - 1] = MessageFormat.format(SPELL_CHECKER_ADD, word);
            this.createMarker((IResource)file, options, offset + column, word, lineNumber);
            ++i;
        }
    }

    private void createMarker(IResource file, String[] proposals, int charBegin, String word, int lineNumber) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("charStart", charBegin);
        attributes.put("charEnd", charBegin + word.length());
        attributes.put("lineNumber", lineNumber);
        attributes.put("severity", 1);
        attributes.put("message", MessageFormat.format(TexlipsePlugin.getResourceString("spellMarkerMessage"), word));
        try {
            IMarker marker = file.createMarker(SPELLING_ERROR_MARKER_TYPE);
            marker.setAttributes(attributes);
            this.proposalMap.put(marker, proposals);
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Adding spelling marker", e);
        }
    }

    public static void clearMarkers(IResource resource) {
        instance.deleteOldProposals(resource);
    }

    private void deleteOldProposals(IResource res) {
        for (IMarker marker : this.proposalMap.keySet()) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                TexlipsePlugin.log("Deleting marker", e);
            }
        }
        try {
            res.deleteMarkers(SPELLING_ERROR_MARKER_TYPE, false, 1);
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Deleting markers", e);
        }
        this.proposalMap.clear();
    }

    public static String[] getProposals(IMarker marker) {
        return SpellChecker.instance.proposalMap.get(marker);
    }

    private static int[] getMarkerPosition(IMarker marker, ISourceViewer sourceViewer) {
        int[] p = new int[]{marker.getAttribute("charStart", -1), marker.getAttribute("charEnd", -1)};
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        if (model instanceof AbstractMarkerAnnotationModel) {
            AbstractMarkerAnnotationModel markerModel = (AbstractMarkerAnnotationModel)model;
            Position pos = markerModel.getMarkerPosition(marker);
            if (pos != null && !pos.isDeleted()) {
                p[0] = pos.getOffset();
                p[1] = pos.getOffset() + pos.getLength();
            }
            if (pos != null && pos.isDeleted()) {
                return null;
            }
        }
        return p;
    }

    public static ICompletionProposal[] getSpellingProposal(int offset, ISourceViewer sourceViewer) {
        IResource res = SelectedResourceManager.getDefault().getSelectedResource();
        if (res == null) {
            return null;
        }
        IMarker[] markers = null;
        try {
            markers = res.findMarkers(SPELLING_ERROR_MARKER_TYPE, false, 0);
        }
        catch (CoreException coreException) {
            return null;
        }
        int i = 0;
        while (i < markers.length) {
            int[] p = SpellChecker.getMarkerPosition(markers[i], sourceViewer);
            if (p != null && p[0] <= offset && offset <= p[1]) {
                try {
                    markers[i].setAttribute("charStart", p[0]);
                    markers[i].setAttribute("charEnd", p[1]);
                }
                catch (CoreException e) {
                    TexlipsePlugin.log("Error while updating Marker", e);
                }
                SpellingResolutionGenerator gen = new SpellingResolutionGenerator();
                return SpellChecker.convertAll(gen.getResolutions(markers[i]), markers[i]);
            }
            ++i;
        }
        return null;
    }

    private static ICompletionProposal[] convertAll(IMarkerResolution[] resolutions, IMarker marker) {
        ICompletionProposal[] array = new ICompletionProposal[resolutions.length];
        int i = 0;
        while (i < resolutions.length) {
            SpellingMarkerResolution smr = (SpellingMarkerResolution)resolutions[i];
            array[i] = new SpellingCompletionProposal(smr.getSolution(), marker);
            ++i;
        }
        return array;
    }

    static class SpellCheckJob
    extends WorkspaceJob {
        private IDocument document;
        private IFile file;

        public SpellCheckJob(String name, IDocument doc, IFile file) {
            super(name);
            this.document = doc;
            this.file = file;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) {
            SpellChecker.checkSpellingDirectly(this.document, this.file, monitor);
            return new Status(0, TexlipsePlugin.getPluginId(), 0, "ok", null);
        }
    }
}

