/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFObject;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class PDFName
extends PDFObject {
    static Map nameCache = new HashMap(501);
    public static final PDFName A = PDFName.forString("A");
    public static final PDFName a = PDFName.forString("a");
    public static final PDFName ACTION = PDFName.forString("Action");
    public static final PDFName ANNOT = PDFName.forString("Annot");
    public static final PDFName ANNOTS = PDFName.forString("Annots");
    public static final PDFName ASCII85DECODE = PDFName.forString("ASCII85Decode");
    public static final PDFName ASCIIHEXDECODE = PDFName.forString("ASCIIHexDecode");
    public static final PDFName BITSPERCOMPONENT = PDFName.forString("BitsPerComponent");
    public static final PDFName CATALOG = PDFName.forString("Catalog");
    public static final PDFName CCITTFAXDECODE = PDFName.forString("CCITTFaxDecode");
    public static final PDFName COLORSPACE = PDFName.forString("ColorSpace");
    public static final PDFName CONTENTS = PDFName.forString("Contents");
    public static final PDFName COUNT = PDFName.forString("Count");
    public static final PDFName CROPBOX = PDFName.forString("CropBox");
    public static final PDFName D = PDFName.forString("D");
    public static final PDFName DCTDECODE = PDFName.forString("DCTDecode");
    public static final PDFName DECODEPARMS = PDFName.forString("DecodeParms");
    public static final PDFName DEST = PDFName.forString("Dest");
    public static final PDFName DESTS = PDFName.forString("Dests");
    public static final PDFName DEVICERGB = PDFName.forString("DeviceRGB");
    public static final PDFName DUR = PDFName.forString("Dur");
    public static final PDFName FILTER = PDFName.forString("Filter");
    public static final PDFName FIRSTPAGE = PDFName.forString("FirstPage");
    public static final PDFName FIT = PDFName.forString("Fit");
    public static final PDFName FITB = PDFName.forString("FitB");
    public static final PDFName FITBH = PDFName.forString("FitBH");
    public static final PDFName FITBV = PDFName.forString("FitBV");
    public static final PDFName FITH = PDFName.forString("FitH");
    public static final PDFName FITR = PDFName.forString("FitR");
    public static final PDFName FITV = PDFName.forString("FitV");
    public static final PDFName FLATEDECODE = PDFName.forString("FlateDecode");
    public static final PDFName FONT = PDFName.forString("Font");
    public static final PDFName GOTO = PDFName.forString("GoTo");
    public static final PDFName HEIGHT = PDFName.forString("Height");
    public static final PDFName HID = PDFName.forString("Hid");
    public static final PDFName INFO = PDFName.forString("Info");
    public static final PDFName KIDS = PDFName.forString("Kids");
    public static final PDFName LASTPAGE = PDFName.forString("LastPage");
    public static final PDFName LENGTH = PDFName.forString("Length");
    public static final PDFName LINK = PDFName.forString("Link");
    public static final PDFName LZWDECODE = PDFName.forString("LZWDecode");
    public static final PDFName MEDIABOX = PDFName.forString("MediaBox");
    public static final PDFName N = PDFName.forString("N");
    public static final PDFName NAMED = PDFName.forString("Named");
    public static final PDFName NAMES = PDFName.forString("Names");
    public static final PDFName NEXTPAGE = PDFName.forString("NextPage");
    public static final PDFName NUMS = PDFName.forString("Nums");
    public static final PDFName PAGE = PDFName.forString("Page");
    public static final PDFName PAGELABEL = PDFName.forString("PageLabel");
    public static final PDFName PAGELABELS = PDFName.forString("PageLabels");
    public static final PDFName PAGES = PDFName.forString("Pages");
    public static final PDFName PARENT = PDFName.forString("Parent");
    public static final PDFName PREV = PDFName.forString("Prev");
    public static final PDFName PREVPAGE = PDFName.forString("PrevPage");
    public static final PDFName RECT = PDFName.forString("Rect");
    public static final PDFName RESOURCES = PDFName.forString("Resources");
    public static final PDFName R = PDFName.forString("R");
    public static final PDFName r = PDFName.forString("r");
    public static final PDFName ROOT = PDFName.forString("Root");
    public static final PDFName ROTATE = PDFName.forString("Rotate");
    public static final PDFName RUNLENGTHDECODE = PDFName.forString("RunLengthDecode");
    public static final PDFName SIZE = PDFName.forString("Size");
    public static final PDFName SUBTYPE = PDFName.forString("Subtype");
    public static final PDFName S = PDFName.forString("S");
    public static final PDFName St = PDFName.forString("St");
    public static final PDFName TEXT = PDFName.forString("Text");
    public static final PDFName THUMB = PDFName.forString("Thumb");
    public static final PDFName TRANS = PDFName.forString("Trans");
    public static final PDFName TYPE = PDFName.forString("Type");
    public static final PDFName XYZ = PDFName.forString("XYZ");
    public static final PDFName XOBJECT = PDFName.forString("XObject");
    public static final PDFName WIDTH = PDFName.forString("Width");
    String val;
    static final char PREFIX = '/';
    static final char ESCAPECHAR = '#';
    private static final boolean[] isRegular = new boolean[128];

    static {
        int i = 0;
        while (i < 128) {
            PDFName.isRegular[i] = i >= 33 && i <= 126 && i != 37 && i != 40 && i != 41 && i != 60 && i != 62 && i != 91 && i != 93 && i != 123 && i != 125 && i != 47 && i != 35;
            ++i;
        }
    }

    private PDFName(String init) {
        if (init == null || init.length() == 0 || init.indexOf(0) != -1) {
            throw new IllegalArgumentException("PDFName: init may not be null or \"\" and may not contain the character 0x00");
        }
        this.val = init;
    }

    public boolean equals(Object obj) {
        return obj instanceof PDFName && this.val.equals(((PDFName)obj).val);
    }

    public static PDFName forString(String init) throws IllegalArgumentException {
        PDFName res = (PDFName)nameCache.get(init);
        if (res == null) {
            res = new PDFName(init);
            nameCache.put(init, res);
        }
        return res;
    }

    public int hashCode() {
        return this.val.hashCode();
    }

    public String toString() {
        return this.val.toString();
    }

    public void write(Writer out) throws IOException {
        out.write(47);
        int vLength = this.val.length();
        int i = 0;
        while (i < vLength) {
            char cur = this.val.charAt(i);
            if (cur < '\u0080' && isRegular[cur]) {
                out.write(cur);
            } else {
                out.write(35);
                out.write(Character.forDigit(cur / 16, 16));
                out.write(Character.forDigit(cur % 16, 16));
            }
            ++i;
        }
    }
}

