/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.common.packet;

import java.io.IOException;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.ResultPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.mysql.MySQLProtocol;

public class ResultSetPacket
extends ResultPacket {
    private final long fieldCount;

    public ResultSetPacket(RawPacket rawPacket) throws IOException {
        Reader reader = new Reader(rawPacket);
        this.fieldCount = reader.getLengthEncodedBinary();
        if (this.fieldCount == -1L) {
            throw new AssertionError((Object)"field count is -1 in ResultSetPacket.");
        }
        if (reader.getRemainingSize() != 0) {
            throw new IOException("invalid packet contents ,expected result set packet, actual packet hexdump = " + MySQLProtocol.hexdump(rawPacket.getByteBuffer(), 0));
        }
    }

    @Override
    public ResultPacket.ResultType getResultType() {
        return ResultPacket.ResultType.RESULTSET;
    }

    @Override
    public byte getPacketSeq() {
        return 0;
    }

    public long getFieldCount() {
        return this.fieldCount;
    }
}

