/*
 * top-level comments are comments starting with %
 * For simplicity, we allow such comments only outside of all other entries.
 * Created on Mar 17, 2003
 *
 * @author henkel@cs.colorado.edu
 * 
 */
package bibtex.dom;

import java.io.PrintWriter;
import java.io.Serializable;

/**
 * @author 	henkel
 * @author 	Yann-Gal Guhneuc
 */
public class BibtexToplevelComment
	extends BibtexAbstractEntry
	implements Serializable {

	protected BibtexToplevelComment(String content) {
		this.content = content;
	}

	private String content;

	/**
	 * @return String
	 */
	public String getContent() {
		return content;
	}

	/**
	 * Sets the content.
	 * @param content The content to set
	 */
	public void setContent(String content) {
		this.content = content;
	}

	/* (non-Javadoc)
	 * @see bibtex.dom.BibtexNode#printBibtex(java.io.PrintWriter)
	 */
	public void print(PrintWriter writer) {
		writer.println(this.content);
	}
}
