/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.common;

import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.bibgls.common.Bib2GlsSyntaxException;
import com.dickimawbooks.bibgls.common.BibGlsArgValue;
import com.dickimawbooks.bibgls.common.BibGlsArgValueType;
import com.dickimawbooks.bibgls.common.BibGlsConverterListener;
import com.dickimawbooks.bibgls.common.BibGlsTeXApp;
import com.dickimawbooks.texparserlib.CaseChange;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.TeXReader;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.html.L2HStringConverter;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.NewCommand;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.latex3.NewDocumentCommand;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Vector;

public abstract class BibGlsConverter
extends BibGlsTeXApp {
    protected File texFile = null;
    protected File bibFile = null;
    protected String bibCharsetName = null;
    protected Charset charset;
    protected boolean overwriteFiles = true;
    protected boolean preambleOnly = false;
    protected boolean noDescEntryToIndex = false;
    protected String spaceSub = null;
    protected boolean autoTrimLabel = true;
    protected Vector<String> customIgnoreFields = null;
    protected HashMap<String, String> keyToFieldMap = null;
    protected CaseChange fieldCaseChange = CaseChange.TO_LOWER;
    private HashMap<String, String> labelMap = new HashMap();
    private HashMap<String, String> reverseLabelMap = new HashMap();
    protected TeXParser parser;
    protected BibGlsConverterListener listener;
    protected L2HStringConverter interpreter = null;
    protected TeXParser interpreterParser = null;

    @Override
    protected void initialise(String[] stringArray) throws Bib2GlsException, IOException {
        super.initialise(stringArray);
        this.listener = new BibGlsConverterListener(this, this.preambleOnly);
        this.parser = new TeXParser((TeXParserListener)this.listener);
        this.parser.setDebugMode(this.debugLevel);
        if (this.debugLevel > 0 && this.logName == null) {
            this.logName = this.getApplicationName() + ".log";
        }
        this.initTranscript();
        if (this.logWriter != null) {
            this.parser.setLogWriter(this.logWriter);
            this.parser.setLogging(true);
        }
    }

    public String kpsewhich(String string) {
        return null;
    }

    public TeXObjectList createString(String string) {
        return this.listener.createString(string);
    }

    public TeXParser getParser() {
        return this.parser;
    }

    public Charset getCharSet() {
        return this.charset == null ? this.getDefaultCharset() : this.charset;
    }

    public BibGlsConverterListener getListener() {
        return this.listener;
    }

    protected void addPredefinedCommands(TeXParser teXParser) {
        teXParser.putControlSequence((ControlSequence)new NewCommand("renewcommand", Overwrite.ALLOW));
        teXParser.putControlSequence((ControlSequence)new NewDocumentCommand("RenewDocumentCommand", Overwrite.ALLOW));
        teXParser.putControlSequence((ControlSequence)new AtFirstOfTwo("IfNotBibGls"));
    }

    public boolean newcommandOverride(boolean bl, Overwrite overwrite, String string, String string2, boolean bl2, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        return false;
    }

    public boolean isSpecialUsePackage(KeyValList keyValList, String string, boolean bl, TeXObjectList teXObjectList) throws IOException {
        return false;
    }

    public void removeLabelMapping(String string) {
        String string2 = this.labelMap.get(string);
        if (string2 != null) {
            this.labelMap.remove(string);
            this.reverseLabelMap.remove(string2);
        }
    }

    public void removeLabelMapping(String string, String string2) {
        String string3 = this.labelMap.get(string);
        String string4 = this.reverseLabelMap.get(string2);
        if (string3 != null) {
            this.debugMessage("common.removed_label_reverse_mapping_found", string, string3);
            this.reverseLabelMap.remove(string3);
        }
        if (string4 != null) {
            this.debugMessage("common.removed_label_mapping_found", string2, string4);
            this.labelMap.remove(string4);
        }
        if (this.labelMap.remove(string) != null) {
            this.debugMessage("common.removed_label_map", string);
        }
        if (this.reverseLabelMap.remove(string2) != null) {
            this.debugMessage("common.removed_reverse_label_map", string2);
        }
    }

    public void addLabelMapping(String string, String string2) throws NullPointerException, IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException("Null original label");
        }
        if (string2 == null) {
            throw new NullPointerException("Null new label");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Empty label not permitted");
        }
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("Empty label mapping not permitted");
        }
        this.removeLabelMapping(string, string2);
        this.debugMessage("common.added_label_map", string, string2);
        this.labelMap.put(string, string2);
        this.reverseLabelMap.put(string2, string);
    }

    public boolean hasLabelMapping(String string) {
        return this.labelMap.containsKey(string);
    }

    public boolean isMappedLabel(String string) {
        return this.reverseLabelMap.containsKey(string);
    }

    public String getMappedLabel(String string) {
        return this.labelMap.get(string);
    }

    public String getOriginalLabel(String string) {
        return this.reverseLabelMap.get(string);
    }

    /*
     * WARNING - void declaration
     */
    public String processLabel(String string) {
        int n;
        void var3_4;
        char c;
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        int c2 = string.length();
        if (this.autoTrimLabel && this.spaceSub != null) {
            for (n2 = string.length() - 1; n2 > 0 && (Character.isWhitespace(c = (char)string.charAt(n2)) || Character.isSpaceChar(c)); --n2) {
                --var3_4;
            }
        }
        n2 = -1;
        for (c = '\u0000'; c < var3_4; c += Character.charCount(n)) {
            n = string.codePointAt(c);
            if (!Character.isWhitespace(n) && !Character.isSpaceChar(n)) continue;
            if (this.spaceSub == null || this.autoTrimLabel && stringBuilder.length() == 0 || n2 >= stringBuilder.length() - this.spaceSub.length()) continue;
            n2 = stringBuilder.length();
            stringBuilder.append(this.spaceSub);
        }
        if (n2 >= 0 && n2 == stringBuilder.length() - this.spaceSub.length()) {
            stringBuilder.setLength(n2);
        }
        this.debugMessage("common.label.processed", string, stringBuilder);
        return stringBuilder.toString();
    }

    public String interpret(TeXObject teXObject) {
        return this.interpret(teXObject, true);
    }

    protected void initInterpreter() {
        this.interpreter = new L2HStringConverter((TeXApp)this);
        this.interpreterParser = new TeXParser((TeXParserListener)this.interpreter);
        this.interpreter.setIsInDocEnv(true);
        this.interpreter.setUndefinedAction(this.isDebuggingOn() ? UndefAction.MESSAGE : UndefAction.IGNORE);
    }

    public String interpret(TeXObject teXObject, boolean bl) {
        String string = teXObject.toString(this.parser);
        if (this.interpreter == null) {
            this.initInterpreter();
        }
        try {
            StringWriter stringWriter = new StringWriter();
            this.interpreter.setWriter((Writer)stringWriter);
            if (this.isDebuggingOn()) {
                this.logAndPrintMessage(String.format("%n%s%n%s%n%n", this.getMessage("message.parsing.code"), string));
            }
            this.interpreterParser.parse(new TeXReader((TeXApp)this, string));
            String string2 = stringWriter.toString();
            this.interpreter.setWriter(null);
            if (this.isDebuggingOn()) {
                this.logAndPrintMessage(String.format("texparserlib:--> %s", string2));
            }
            string2 = string2.replaceAll("<[^>]+>", "");
            string2 = string2.replaceAll("\\&le;", "<");
            string2 = string2.replaceAll("\\&ge;", ">");
            string2 = string2.replaceAll("\\&amp;", "&");
            if (bl) {
                string2 = string2.trim();
            }
            this.logMessage(String.format("texparserlib: %s -> %s", string, string2));
            return string2;
        }
        catch (IOException iOException) {
            if (this.isDebuggingOn()) {
                this.debug("texparserlib: ");
                this.debug(iOException);
            }
            return string;
        }
    }

    protected boolean isIgnoredPackage(String string) {
        return false;
    }

    public boolean isIndexConversionOn() {
        return this.noDescEntryToIndex;
    }

    @Override
    protected int argCount(String string) {
        if (string.equals("--texenc") || string.equals("--bibenc") || string.equals("--space-sub") || string.equals("-s") || string.equals("--ignore-fields") || string.equals("-f") || string.equals("--log-file") || string.equals("--field-map") || string.equals("--key-map") || string.equals("-m")) {
            return 1;
        }
        return super.argCount(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean parseArg(ArrayDeque<String> arrayDeque, String string, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        if (this.isArg(arrayDeque, string, "--texenc", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.encoding.value", string));
            }
            this.charset = Charset.forName(bibGlsArgValueArray[0].toString());
            return true;
        } else if (this.isArg(arrayDeque, string, "--bibenc", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.encoding.value", string));
            }
            this.bibCharsetName = bibGlsArgValueArray[0].toString();
            return true;
        } else if (this.isArg(arrayDeque, string, "--log-file", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.error.missing.value", string));
            }
            this.logName = bibGlsArgValueArray[0].toString().trim();
            if (!this.logName.isEmpty()) return true;
            this.logName = null;
            return true;
        } else if (this.isArg(arrayDeque, string, "-s", "--space-sub", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            this.spaceSub = bibGlsArgValueArray[0].toString();
            if (!" ".equals(this.spaceSub)) return true;
            this.spaceSub = null;
            return true;
        } else if (string.equals("--auto-trim")) {
            this.autoTrimLabel = true;
            return true;
        } else if (string.equals("--no-auto-trim")) {
            this.autoTrimLabel = false;
            return true;
        } else if (string.equals("--overwrite")) {
            this.overwriteFiles = true;
            return true;
        } else if (string.equals("--no-overwrite")) {
            this.overwriteFiles = false;
            return true;
        } else if (string.equals("--no-ignore-fields")) {
            this.customIgnoreFields = null;
            return true;
        } else if (this.isListArg(arrayDeque, string, "-f", "--ignore-fields", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            if (bibGlsArgValueArray[0].toString().isEmpty()) return true;
            this.addCustomIgnoreField(bibGlsArgValueArray[0].listValue());
            return true;
        } else if (string.equals("--no-field-map") || string.equals("--no-key-map")) {
            this.keyToFieldMap = null;
            return true;
        } else if (this.isArg(arrayDeque, string, "-m", "--field-map", "--key-map", bibGlsArgValueArray, BibGlsArgValueType.LIST)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            if (this.keyToFieldMap == null) {
                this.keyToFieldMap = new HashMap();
            }
            for (String string2 : bibGlsArgValueArray[0].listValue()) {
                String[] stringArray = string2.split(" *= *");
                if (stringArray.length != 2) {
                    throw new Bib2GlsSyntaxException(this.getMessage("datatool2bib.syntax.invalid_map", string2, string));
                }
                this.keyToFieldMap.put(stringArray[0], stringArray[1]);
            }
            return true;
        } else if (this.isArg(arrayDeque, string, "--field-case", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            String string3 = bibGlsArgValueArray[0].toString().trim();
            if (string3.equals("none")) {
                this.fieldCaseChange = CaseChange.NO_CHANGE;
                return true;
            } else if (string3.equals("lc")) {
                this.fieldCaseChange = CaseChange.TO_LOWER;
                return true;
            } else if (string3.equals("uc")) {
                this.fieldCaseChange = CaseChange.TO_UPPER;
                return true;
            } else if (string3.equals("title")) {
                this.fieldCaseChange = CaseChange.TITLE;
                return true;
            } else {
                if (!string3.equals("sentence")) throw new Bib2GlsSyntaxException(this.getMessage("error.invalid.choice.value", string, string3, "none, lc, uc, title, sentence"));
                this.fieldCaseChange = CaseChange.SENTENCE;
            }
            return true;
        } else if (string.equals("--preamble-only") || string.equals("-p")) {
            this.preambleOnly = true;
            return true;
        } else if (string.equals("--no-preamble-only")) {
            this.preambleOnly = false;
            return true;
        } else if (string.equals("--index-conversion") || string.equals("-i")) {
            this.noDescEntryToIndex = true;
            return true;
        } else {
            if (!string.equals("--no-index-conversion")) return false;
            this.noDescEntryToIndex = false;
        }
        return true;
    }

    @Override
    protected void parseArg(ArrayDeque<String> arrayDeque, String string) throws Bib2GlsSyntaxException {
        if (this.texFile == null) {
            this.texFile = new File(string);
        } else if (this.bibFile == null) {
            this.bibFile = string.toLowerCase().endsWith(".bib") ? new File(string) : new File(string + ".bib");
        } else {
            throw new Bib2GlsSyntaxException(this.getMessage("common.toomany.arg", "--help"));
        }
    }

    @Override
    protected void initSettings() throws Bib2GlsSyntaxException {
    }

    @Override
    protected void postSettings() throws Bib2GlsSyntaxException {
        if (this.texFile == null) {
            throw new Bib2GlsSyntaxException(this.getMessage("common.missing.tex.arg", this.getMessage("common.syntax", this.getApplicationName()), "--help"));
        }
        if (this.bibFile == null) {
            throw new Bib2GlsSyntaxException(this.getMessage("common.missing.bib.arg", this.getMessage("common.syntax", this.getApplicationName()), "--help"));
        }
        if (this.bibCharsetName == null) {
            this.bibCharsetName = this.defaultCharset.name();
        }
    }

    public void addCustomIgnoreField(String ... stringArray) {
        if (this.customIgnoreFields == null) {
            this.customIgnoreFields = new Vector();
        }
        for (String string : stringArray) {
            if (string.isEmpty()) continue;
            this.customIgnoreFields.add(string.toLowerCase());
        }
    }

    public boolean isCustomIgnoreField(String string) {
        if (this.customIgnoreFields == null) {
            return false;
        }
        return this.customIgnoreFields.contains(string.toLowerCase());
    }

    public void addKeyToFieldMap(String string, String string2) {
        if (this.keyToFieldMap == null) {
            this.keyToFieldMap = new HashMap();
        }
        this.keyToFieldMap.put(string, string2);
    }

    public String getFieldMap(String string) {
        if (this.keyToFieldMap == null) {
            return null;
        }
        return this.keyToFieldMap.get(string);
    }

    public String getFieldName(String string) {
        String string2;
        String string3 = string;
        if (this.isCustomIgnoreField(string)) {
            string3 = null;
        } else {
            if (this.keyToFieldMap != null && (string2 = this.keyToFieldMap.get(string)) != null) {
                string3 = string2;
            }
            if (string3.isEmpty()) {
                if (string.isEmpty()) {
                    this.warningMessage("common.empty_field_name", new Object[0]);
                } else {
                    this.warningMessage("common.empty_field_name.changed", string, "field-map");
                }
                string3 = null;
            }
        }
        if (string3 == null) {
            return null;
        }
        string2 = this.processLabel(this.applyFieldCase(string3));
        if (string2.isEmpty()) {
            if (string3.equals(string)) {
                this.warningMessage("common.empty_field_name.changed", string, "--field-map");
            } else {
                this.warningMessage("common.empty_field_name.mapped_changed", string, string3, "--field-map");
            }
            return null;
        }
        return string2;
    }

    protected String applyFieldCase(String string) {
        switch (this.fieldCaseChange) {
            case TO_LOWER: {
                return string.toLowerCase();
            }
            case TO_UPPER: {
                return string.toUpperCase();
            }
            case TITLE: 
            case SENTENCE: {
                StringBuilder stringBuilder = new StringBuilder(string.length());
                int n = string.codePointAt(0);
                stringBuilder.appendCodePoint(Character.toTitleCase(n));
                stringBuilder.append(string, Character.charCount(n), string.length());
                return stringBuilder.toString();
            }
        }
        return string;
    }

    public boolean isCaseChanger(TeXObject teXObject) {
        return TeXParserUtils.isControlSequence((TeXObject)teXObject, (String[])new String[]{"capitalisewords", "xcapitalisewords", "ecapitalisewords", "capitalisefmtwords", "xcapitalisefmtwords", "ecapitalisefmtwords", "makefirstuc", "xmakefirstuc", "emakefirstuc", "glsmakefirstuc", "uppercase", "lowercase", "glsuppercase", "glslowercase", "MakeTextUppercase", "MakeTextLowercase", "MFUsentencecase", "MakeUppercase", "MakeLowercase", "mfirstucMakeUppercase"});
    }

    protected void localeHelp() {
        this.printSyntaxItem(this.getMessage("common.syntax.texenc", "--texenc"));
        this.printSyntaxItem(this.getMessage("common.syntax.bibenc", "--bibenc"));
        this.printSyntaxItem(this.getMessage("common.syntax.locale", "--locale"));
        System.out.println();
    }

    protected void filterHelp() {
        this.printSyntaxItem(this.getMessage("common.syntax.preamble-only", "--[no-]preamble-only", "-p"));
        this.printSyntaxItem(this.getMessage("common.syntax.ignore-fields", "--[no-]ignore-fields", "-f"));
    }

    protected void ioHelp() {
        this.printSyntaxItem(this.getMessage("common.syntax.overwrite", "--[no-]overwrite"));
    }

    protected void adjustHelp() {
        this.printSyntaxItem(this.getMessage("common.syntax.space-sub", "--space-sub", "-s"));
        this.printSyntaxItem(this.getMessage("common.syntax.auto-trim", "--[no-]auto-trim"));
        this.printSyntaxItem(this.getMessage("common.syntax.index-conversion", "--[no-]index-conversion", "-i"));
        this.printSyntaxItem(this.getMessage("common.syntax.field-map", "--[no-]field-map", "-m"));
        this.printSyntaxItem(this.getMessage("common.syntax.field-case", "--field-case", "none, lc, uc, title, sentence"));
    }

    protected void otherHelp() {
    }

    protected abstract void syntaxInfo();

    @Override
    public void help() {
        System.out.println(this.getMessage("common.syntax", this.getApplicationName()));
        System.out.println();
        this.syntaxInfo();
        System.out.println();
        System.out.println(this.getMessage("common.syntax.options.general"));
        System.out.println();
        this.commonHelp();
        this.printSyntaxItem(this.getMessage("common.syntax.log-file", "--log-file"));
        System.out.println();
        this.printSyntaxItem(this.getMessage("common.syntax.options.locale"));
        System.out.println();
        this.localeHelp();
        System.out.println(this.getMessage("common.syntax.options.filter"));
        System.out.println();
        this.filterHelp();
        System.out.println();
        System.out.println(this.getMessage("common.syntax.options.io"));
        System.out.println();
        this.ioHelp();
        System.out.println();
        System.out.println(this.getMessage("common.syntax.options.adjust"));
        System.out.println();
        this.adjustHelp();
        this.otherHelp();
        System.out.println();
        System.out.println(this.getMessage("syntax.furtherinfo"));
        System.out.println();
        this.furtherInfo();
    }

    public abstract void process() throws IOException, Bib2GlsException;

    public void run(String[] stringArray) {
        try {
            this.initialise(stringArray);
            this.process();
        }
        catch (Bib2GlsSyntaxException bib2GlsSyntaxException) {
            System.err.println(bib2GlsSyntaxException.getMessage());
            this.exitCode = 1;
        }
        catch (Bib2GlsException bib2GlsException) {
            System.err.println(bib2GlsException.getMessage());
            this.exitCode = 3;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
            this.exitCode = 2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exitCode = 4;
        }
        this.exit();
    }
}

