/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.flowfram;

import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.L2HImage;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.flowfram.FlowFrameType;
import java.awt.Color;
import java.io.IOException;
import java.util.Locale;

public class FlowFrameData {
    FlowFrameType type;
    String label;
    int id;
    String pages = "all";
    String excludePages = "";
    boolean bordered = false;
    boolean hidden = false;
    boolean clear = false;
    String frameCsName = "fbox";
    String style;
    TeXDimension width;
    TeXDimension height;
    TeXDimension posX;
    TeXDimension posY;
    TeXDimension offset;
    TeXDimension oddPosX;
    TeXDimension oddPosY;
    TeXDimension evenPosX;
    TeXDimension evenPosY;
    Color borderCol;
    Color textCol;
    Color backCol;
    char vAlign = (char)98;
    MarginSide marginSide;
    TeXNumber angle;
    TeXObject shape;
    TeXObject content;
    String css;
    int imgNum = 0;

    public FlowFrameData(FlowFrameType flowFrameType, String string, int n, boolean bl, TeXDimension teXDimension, TeXDimension teXDimension2, TeXDimension teXDimension3, TeXDimension teXDimension4) {
        if (flowFrameType == null) {
            throw new NullPointerException();
        }
        this.type = flowFrameType;
        this.id = n;
        this.bordered = bl;
        this.setLabel(string);
        this.setWidth(teXDimension);
        this.setHeight(teXDimension2);
        this.setX(teXDimension3);
        this.setY(teXDimension4);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FlowFrameData)) {
            return false;
        }
        FlowFrameData flowFrameData = (FlowFrameData)object;
        return this.type == flowFrameData.type && this.id == flowFrameData.id && this.label.equals(flowFrameData.label);
    }

    public FlowFrameType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.label = string;
    }

    public int getID() {
        return this.id;
    }

    public boolean isBordered() {
        return this.bordered;
    }

    public void setBordered(boolean bl) {
        this.bordered = bl;
    }

    public void setFrameBorderCsName(String string) {
        if (string.equals("plain")) {
            this.bordered = true;
            this.frameCsName = "fbox";
        } else if (string.equals("none") || string.equals("relax") || string.isEmpty()) {
            this.bordered = false;
            this.frameCsName = "";
        } else {
            this.bordered = true;
            this.frameCsName = string;
        }
    }

    public String getFrameBorderCsName() {
        return this.frameCsName;
    }

    public String getPageList() {
        return this.pages;
    }

    public void setPageList(String string) {
        this.pages = string;
    }

    public String getExcludedPageList() {
        return this.excludePages;
    }

    public void setExcludedPageList(String string) {
        this.excludePages = string;
    }

    public TeXDimension getWidth() {
        return this.width;
    }

    public void setWidth(TeXDimension teXDimension) {
        if (teXDimension == null) {
            throw new NullPointerException();
        }
        this.width = teXDimension;
    }

    public TeXDimension getHeight() {
        return this.height;
    }

    public void setHeight(TeXDimension teXDimension) {
        if (teXDimension == null) {
            throw new NullPointerException();
        }
        this.height = teXDimension;
    }

    public TeXDimension getX() {
        return this.posX;
    }

    public void setX(TeXDimension teXDimension) {
        if (teXDimension == null) {
            throw new NullPointerException();
        }
        this.posX = teXDimension;
    }

    public TeXDimension getY() {
        return this.posY;
    }

    public void setY(TeXDimension teXDimension) {
        if (teXDimension == null) {
            throw new NullPointerException();
        }
        this.posY = teXDimension;
    }

    public TeXDimension getOddX() {
        return this.oddPosX;
    }

    public void setOddX(TeXDimension teXDimension) {
        this.oddPosX = teXDimension;
    }

    public TeXDimension getOddY() {
        return this.oddPosY;
    }

    public void setOddY(TeXDimension teXDimension) {
        this.oddPosY = teXDimension;
    }

    public TeXDimension getEvenX() {
        return this.evenPosX;
    }

    public void setEvenX(TeXDimension teXDimension) {
        this.evenPosX = teXDimension;
    }

    public TeXDimension getEvenY() {
        return this.evenPosY;
    }

    public void setEvenY(TeXDimension teXDimension) {
        this.evenPosY = teXDimension;
    }

    public void swapEvenOdd() {
        TeXDimension teXDimension = this.evenPosX;
        this.evenPosX = this.oddPosX;
        this.oddPosX = teXDimension;
        teXDimension = this.evenPosY;
        this.evenPosY = this.oddPosY;
        this.oddPosY = teXDimension;
    }

    public TeXDimension getOffset() {
        return this.offset;
    }

    public void setOffset(TeXDimension teXDimension) {
        this.offset = teXDimension;
    }

    public void setVAlign(char c) throws IllegalArgumentException {
        switch (this.type) {
            case STATIC: 
            case DYNAMIC: {
                if (c == 'c' || c == 't' || c == 'b') {
                    this.vAlign = c;
                    break;
                }
                throw new IllegalArgumentException("Invalid valign " + c);
            }
            default: {
                throw new IllegalArgumentException("valign not permitted for frame type " + (Object)((Object)this.type));
            }
        }
    }

    public void setBorderColor(Color color) {
        this.borderCol = color;
    }

    public Color getBorderColor() {
        return this.borderCol;
    }

    public void setTextColor(Color color) {
        this.textCol = color;
    }

    public Color getTextColor() {
        return this.textCol;
    }

    public void setBackColor(Color color) {
        this.backCol = color;
    }

    public Color getBackColor() {
        return this.backCol;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        switch (this.type) {
            case STATIC: 
            case DYNAMIC: {
                this.hidden = bl;
                break;
            }
            default: {
                throw new IllegalArgumentException("hide not permitted for frame type " + (Object)((Object)this.type));
            }
        }
    }

    public boolean isClearOn() {
        return this.clear;
    }

    public void setClear(boolean bl) throws IllegalArgumentException {
        switch (this.type) {
            case STATIC: 
            case DYNAMIC: {
                this.clear = bl;
                break;
            }
            default: {
                throw new IllegalArgumentException("clear not permitted for frame type " + (Object)((Object)this.type));
            }
        }
    }

    public void setMarginSide(String string) throws IllegalArgumentException {
        MarginSide marginSide = MarginSide.valueOf(string.toUpperCase());
        if (marginSide == null) {
            throw new IllegalArgumentException("Invalid margin value " + string);
        }
        this.setMarginSide(marginSide);
    }

    public void setMarginSide(MarginSide marginSide) throws IllegalArgumentException {
        if (this.type != FlowFrameType.FLOW) {
            throw new IllegalArgumentException("margin not permitted for frame type " + (Object)((Object)this.type));
        }
        this.marginSide = marginSide;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean hasStyle() {
        if (this.type == FlowFrameType.DYNAMIC) {
            return this.style != null && !this.style.isEmpty();
        }
        return false;
    }

    public void setStyle(String string) throws IllegalArgumentException {
        if (this.type != FlowFrameType.DYNAMIC) {
            throw new IllegalArgumentException("style not permitted for frame type " + (Object)((Object)this.type));
        }
        this.style = this.style;
    }

    public void setAngle(TeXNumber teXNumber) {
        this.angle = teXNumber;
    }

    public TeXNumber getAngle() {
        return this.angle;
    }

    public boolean hasAngle() {
        return this.angle != null && this.angle.getValue() != 0;
    }

    public TeXObject getShape() {
        return this.shape;
    }

    public boolean hasShape() {
        return this.shape != null && !this.shape.isEmpty();
    }

    public void setShape(TeXObject teXObject) throws IllegalArgumentException {
        if (this.type == FlowFrameType.FLOW) {
            throw new IllegalArgumentException("shape not permitted for frame type " + (Object)((Object)this.type));
        }
        this.shape = TeXParserUtils.isControlSequence(teXObject, "relax") ? null : teXObject;
    }

    public void setCss() {
        this.css = this.css;
    }

    public String getCss() {
        return this.css;
    }

    public TeXObject getContent() {
        return this.content;
    }

    public boolean hasContent() {
        return this.content != null && !this.content.isEmpty();
    }

    public void setContent(TeXObject teXObject) throws IllegalArgumentException {
        if (this.type == FlowFrameType.FLOW) {
            throw new IllegalArgumentException("content not permitted for frame type " + (Object)((Object)this.type));
        }
        this.content = teXObject;
    }

    public void writeCss(L2HConverter l2HConverter) throws IOException {
        l2HConverter.write("div." + (Object)((Object)this.type) + this.label);
        l2HConverter.write(", div." + (Object)((Object)this.type) + this.id);
        l2HConverter.writeln("{");
        l2HConverter.writeliteral(String.format(" width: %s;", l2HConverter.getHtmlDimension(this.width)));
        l2HConverter.writeliteral(String.format(" height: %s;", l2HConverter.getHtmlDimension(this.height)));
        if (this.textCol != null) {
            l2HConverter.writeliteral(String.format(" color: %s;%n", l2HConverter.getHtmlColor(this.textCol)));
        }
        if (this.backCol != null) {
            l2HConverter.writeliteral(String.format(" background-color: %s;%n", l2HConverter.getHtmlColor(this.backCol)));
        }
        if (this.bordered) {
            if ("shadowbox".equals(this.frameCsName)) {
                l2HConverter.writeliteral(" box-shadow: ");
                if (this.borderCol == null) {
                    l2HConverter.writeliteral("black");
                } else {
                    l2HConverter.writeliteral(l2HConverter.getHtmlColor(this.borderCol));
                }
                l2HConverter.writeln(";");
            } else {
                l2HConverter.writeliteral(" border-style: solid;");
                l2HConverter.writeln();
                if (this.borderCol != null) {
                    l2HConverter.writeliteral(String.format(" border-color: %s;%n", l2HConverter.getHtmlColor(this.borderCol)));
                }
                if ("ovalbox".equals(this.frameCsName)) {
                    l2HConverter.writeliteral(" border-radius: 10%;");
                }
            }
        }
        if (this.hasAngle()) {
            String string = String.format("rotate(%fdeg)", -this.angle.doubleValue());
            l2HConverter.writeliteral(String.format("transform: %s; -ms-transform: %s; -webkit-transform: %s;", string, string, string));
        }
        if (this.css != null) {
            l2HConverter.writeliteral(this.css);
            l2HConverter.writeln();
        }
        l2HConverter.writeln("}");
    }

    public void showContent(TeXParser teXParser, TeXObjectList teXObjectList, KeyValList keyValList) throws IOException {
        Boolean bl;
        boolean bl2 = true;
        boolean bl3 = false;
        String string = "image/png";
        TeXObject teXObject = null;
        String string2 = null;
        String string3 = null;
        if (this.content == null || this.content.isEmpty()) {
            return;
        }
        if (this.hasShape()) {
            bl3 = true;
        }
        teXObject = keyValList.getValue("alt");
        String string4 = keyValList.getString("mime-type", teXParser, teXObjectList);
        if (string4 != null) {
            string = string4;
        }
        if ((bl = keyValList.getBoolean("image", teXParser, teXObjectList)) != null) {
            bl3 = bl;
        }
        if ((bl = keyValList.getBoolean("div", teXParser, teXObjectList)) != null) {
            bl2 = bl;
        }
        string2 = keyValList.getString("style", teXParser, teXObjectList);
        string3 = keyValList.getString("class", teXParser, teXObjectList);
        this.process(teXParser, teXObjectList, bl3, teXObject, string, bl2, string2, string3);
    }

    public void process(TeXParser teXParser, TeXObjectList teXObjectList, boolean bl, TeXObject teXObject, String string, boolean bl2, String string2, String string3) throws IOException {
        if (this.content != null) {
            TeXParserListener teXParserListener = teXParser.getListener();
            if (teXParserListener instanceof L2HConverter) {
                teXParser.startGroup();
                String string4 = this.type.toString().toLowerCase();
                L2HConverter l2HConverter = (L2HConverter)teXParserListener;
                TeXObjectList teXObjectList2 = teXParserListener.createStack();
                StartElement startElement = null;
                EndElement endElement = null;
                if (bl2) {
                    startElement = new StartElement("div", true, true);
                    endElement = new EndElement("div", true, true);
                    if (string2 != null) {
                        startElement.putAttribute("style", string2);
                    }
                    if (string3 != null) {
                        startElement.putAttribute("class", string3);
                    }
                }
                if (bl) {
                    if (startElement != null) {
                        TeXParserUtils.process(startElement, teXParser, teXObjectList);
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (this.shape != null) {
                        stringBuilder.append(this.shape.toString(teXParser));
                    }
                    stringBuilder.append("\\null");
                    StringBuilder stringBuilder2 = new StringBuilder(l2HConverter.getImagePreamble());
                    stringBuilder2.append("\\setallflowframes{pages=none}");
                    stringBuilder2.append("\\setallstaticframes{pages=none}");
                    stringBuilder2.append("\\setalldynamicframes{pages=none}");
                    stringBuilder2.append("\\onecolumn");
                    stringBuilder2.append("\\pagestyle{empty}");
                    stringBuilder2.append(String.format((Locale)null, "\\set%sframe{%d}{pages=all}%n", string4, this.id));
                    stringBuilder2.append(String.format((Locale)null, "\\set%scontents{%d}{%s}", string4, this.id, this.content.toString(teXParser)));
                    String string5 = string4;
                    if (this.imgNum > 0) {
                        string5 = string5 + this.imgNum;
                    }
                    ++this.imgNum;
                    L2HImage l2HImage = l2HConverter.toImage(stringBuilder2.toString(), stringBuilder.toString(), string, teXObject, string5, true, null);
                    if (l2HImage != null) {
                        l2HImage.process(teXParser);
                    } else {
                        teXParserListener.getWriteable().writeliteral(String.format("<!-- Image %s Creation Failed -->", string5));
                        teXObject.process(teXParser, teXObjectList);
                        teXParserListener.getWriteable().writeliteral(String.format("<!-- End of Image %s Alt Block -->", string5));
                    }
                    if (endElement != null) {
                        TeXParserUtils.process(endElement, teXParser, teXObjectList);
                    }
                } else {
                    if (startElement != null) {
                        teXObjectList2.add(startElement);
                        if (string3 == null) {
                            startElement.putAttribute("class", (Object)((Object)this.type) + this.label + " " + (Object)((Object)this.type) + this.id);
                        }
                    }
                    teXObjectList2.add((TeXObject)this.content.clone(), true);
                    if (endElement != null) {
                        teXObjectList2.add(endElement);
                    }
                    TeXParserUtils.process(teXObjectList2, teXParser, teXObjectList);
                }
                teXParser.endGroup();
            } else {
                TeXObjectList teXObjectList3;
                TeXObjectList teXObjectList4 = TeXParserUtils.toList((TeXObject)this.content.clone(), teXParser);
                if (this.hasShape()) {
                    teXObjectList4.push((TeXObject)this.shape.clone(), true);
                }
                teXObjectList4.push(TeXParserUtils.createGroup(teXParserListener, this.width));
                teXObjectList4.push(teXParserListener.getOther(93));
                teXObjectList4.push(this.height);
                teXObjectList4.push(teXParserListener.getOther(91));
                teXObjectList4.push(teXParserListener.getOther(93));
                teXObjectList4.push(teXParserListener.getLetter(this.vAlign));
                teXObjectList4.push(teXParserListener.getOther(91));
                teXObjectList4.push(teXParserListener.createGroup("minipage"));
                teXObjectList4.push(teXParserListener.getControlSequence("begin"));
                teXObjectList4.add(teXParserListener.getControlSequence("begin"));
                teXObjectList4.add(teXParserListener.createGroup("minipage"));
                if (this.bordered && this.frameCsName != null) {
                    teXObjectList3 = teXParserListener.createStack();
                    teXObjectList3.add(teXParserListener.getControlSequence(this.frameCsName));
                    teXObjectList3.add(TeXParserUtils.createGroup(teXParserListener, teXObjectList4));
                } else {
                    teXObjectList3 = teXObjectList4;
                }
                if (this.angle != null) {
                    teXObjectList4 = teXObjectList3;
                    teXObjectList3 = TeXParserUtils.createStack(teXParserListener, teXParserListener.getControlSequence("rotatebox"), TeXParserUtils.createGroup(teXParserListener, this.angle), TeXParserUtils.createGroup(teXParserListener, teXObjectList4));
                }
                TeXParserUtils.process(teXObjectList3, teXParser, teXObjectList);
            }
        }
    }

    public String toString() {
        return String.format("%s[type=%s,id=%d,label=%s]", new Object[]{this.getClass().getSimpleName(), this.type, this.id, this.label});
    }

    public static enum MarginSide {
        LEFT,
        RIGHT,
        INNER,
        OUTER;

    }
}

