/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import korlibs.io.util.RangesExtKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.FileType;
import org.islandoftex.arara.api.files.MPPPath;
import org.islandoftex.arara.api.rules.Directive;
import org.islandoftex.arara.api.rules.DirectiveConditionalType;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.rules.DirectiveAssembler;
import org.islandoftex.arara.core.rules.DirectiveConditional;
import org.islandoftex.arara.core.rules.DirectiveFetchingHooks;
import org.islandoftex.arara.core.rules.DirectivesKt;
import org.islandoftex.arara.core.utils.StringExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\fH\u0002J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0015\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0000\u00a2\u0006\u0002\b J2\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00162\u0006\u0010\"\u001a\u00020\u00012\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u00132\u0006\u0010$\u001a\u00020\u001aH\u0007J\u0018\u0010%\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\fH\u0002R$\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/islandoftex/arara/core/rules/Directives;", "", "<init>", "()V", "hooks", "Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;", "getHooks$annotations", "getHooks", "()Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;", "setHooks", "(Lorg/islandoftex/arara/core/rules/DirectiveFetchingHooks;)V", "directivestart", "", "pattern", "directivePattern", "Lkotlin/text/Regex;", "namePattern", "linebreakPattern", "getPotentialDirectiveLines", "", "", "lines", "", "parseOnlyHeader", "", "extractDirectives", "Lorg/islandoftex/arara/api/rules/Directive;", "fileType", "Lorg/islandoftex/arara/api/files/FileType;", "generateDirective", "assembler", "Lorg/islandoftex/arara/core/rules/DirectiveAssembler;", "generateDirective$core", "replicateDirective", "holder", "parameters", "directive", "checkLinePattern", "line", "core"})
@SourceDebugExtension(value={"SMAP\nDirectives.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Directives.kt\norg/islandoftex/arara/core/rules/Directives\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,235:1\n1#2:236\n1563#3:237\n1634#3,3:238\n808#3,11:241\n*S KotlinDebug\n*F\n+ 1 Directives.kt\norg/islandoftex/arara/core/rules/Directives\n*L\n114#1:237\n114#1:238,3\n174#1:241,11\n*E\n"})
public final class Directives {
    @NotNull
    public static final Directives INSTANCE = new Directives();
    @NotNull
    private static DirectiveFetchingHooks hooks = new DirectiveFetchingHooks(null, null, null, 7, null);
    @NotNull
    private static final String directivestart = "^\\s*(\\w+)\\s*(:\\s*(\\{.*\\})\\s*)?";
    @NotNull
    private static final String pattern = "(\\s+(if|while|until|unless)\\s+(\\S.*))?$";
    @NotNull
    private static final Regex directivePattern = new Regex("^\\s*(\\w+)\\s*(:\\s*(\\{.*\\})\\s*)?(\\s+(if|while|until|unless)\\s+(\\S.*))?$");
    @NotNull
    private static final String namePattern = "arara:\\s";
    @NotNull
    private static final Regex linebreakPattern = new Regex("^\\s*-->\\s(.*)$");

    private Directives() {
    }

    @NotNull
    public static final DirectiveFetchingHooks getHooks() {
        return hooks;
    }

    public static final void setHooks(@NotNull DirectiveFetchingHooks directiveFetchingHooks) {
        Intrinsics.checkNotNullParameter(directiveFetchingHooks, "<set-?>");
        hooks = directiveFetchingHooks;
    }

    @JvmStatic
    public static /* synthetic */ void getHooks$annotations() {
    }

    private final Map<Integer, String> getPotentialDirectiveLines(List<String> lines, boolean parseOnlyHeader, String pattern) {
        Regex validLinePattern = new Regex(pattern);
        Regex validLineStartPattern = new Regex(pattern + namePattern);
        Map map2 = new LinkedHashMap();
        Iterator iterator2 = ((Iterable)lines).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            String text2 = (String)iterator2.next();
            MatchResult validLineMatch = Regex.find$default(validLineStartPattern, text2, 0, 2, null);
            if (validLineMatch != null) {
                String line;
                Intrinsics.checkNotNullExpressionValue(text2.substring(RangesExtKt.getEndExclusiveWrapped(validLineMatch.getRange())), "substring(...)");
                map2.put(i + 1, hooks.getProcessPotentialDirective().invoke(i + 1, line));
                continue;
            }
            if (!parseOnlyHeader || this.checkLinePattern(validLinePattern, text2)) continue;
            break;
        }
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Directive> extractDirectives(@NotNull List<String> lines, boolean parseOnlyHeader, @NotNull FileType fileType) throws AraraException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(fileType, "fileType");
        Map<Integer, String> map2 = INSTANCE.getPotentialDirectiveLines(lines, parseOnlyHeader, fileType.getPattern());
        Map<Integer, String> it = map2;
        boolean bl = false;
        Map<Integer, String> map3 = !it.isEmpty() ? map2 : null;
        if (map3 == null) {
            return CollectionsKt.emptyList();
        }
        Map<Integer, String> pairs = map3;
        List assemblers = new ArrayList();
        DirectiveAssembler assembler = new DirectiveAssembler();
        for (Map.Entry entry : pairs.entrySet()) {
            int lineno = ((Number)entry.getKey()).intValue();
            String content = (String)entry.getValue();
            MatchResult linebreakMatch = Regex.find$default(linebreakPattern, content, 0, 2, null);
            if (linebreakMatch != null) {
                if (!assembler.isAppendAllowed()) {
                    String[] stringArray = new String[]{String.valueOf(lineno)};
                    throw new AraraException(StringExtensionsKt.formatString(LanguageController.getMessages().getERROR_VALIDATE_ORPHAN_LINEBREAK(), stringArray));
                }
                assembler.addLineNumber(lineno);
                assembler.appendLine(linebreakMatch.getGroupValues().get(1));
                continue;
            }
            if (assembler.isAppendAllowed()) {
                assemblers.add(assembler);
            }
            assembler = new DirectiveAssembler();
            assembler.addLineNumber(lineno);
            assembler.appendLine(content);
        }
        if (assembler.isAppendAllowed()) {
            assemblers.add(assembler);
        }
        Iterable $this$map$iv = assemblers;
        boolean bl2 = false;
        Iterable lineno = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            DirectiveAssembler directiveAssembler = (DirectiveAssembler)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(INSTANCE.generateDirective$core((DirectiveAssembler)it2));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Directive generateDirective$core(@NotNull DirectiveAssembler assembler) throws AraraException {
        Object object;
        block4: {
            block3: {
                String it;
                String string;
                Intrinsics.checkNotNullParameter(assembler, "assembler");
                object = Regex.find$default(directivePattern, assembler.getText(), 0, 2, null);
                if (object == null) break block3;
                MatchResult match = object;
                boolean bl = false;
                String string2 = string = match.getGroupValues().get(3);
                String string3 = match.getGroupValues().get(1);
                Function4<String, String, org.islandoftex.arara.api.rules.DirectiveConditional, List<Integer>, Directive> function4 = hooks.getBuildDirectiveRaw();
                boolean bl2 = false;
                boolean bl3 = ((CharSequence)it).length() > 0;
                String string4 = bl3 ? string : null;
                it = string = match.getGroupValues().get(5);
                String string5 = string4;
                boolean bl4 = false;
                boolean bl5 = ((CharSequence)it).length() > 0;
                String string6 = bl5 ? string : null;
                String string7 = match.getGroupValues().get(6);
                DirectiveConditionalType directiveConditionalType = DirectivesKt.access$toDirectiveConditional(string6);
                Directive directive = function4.invoke(string3, string5, new DirectiveConditional(directiveConditionalType, string7), assembler.getLineNumbers());
                object = directive;
                if (directive != null) break block4;
            }
            String[] stringArray = new String[]{CollectionsKt.joinToString$default(assembler.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
            throw new AraraException(StringExtensionsKt.formatString(LanguageController.getMessages().getERROR_VALIDATE_INVALID_DIRECTIVE_FORMAT(), stringArray));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<Directive> replicateDirective(@NotNull Object holder, @NotNull Map<String, ? extends Object> parameters, @NotNull Directive directive) throws AraraException {
        Object object;
        Intrinsics.checkNotNullParameter(holder, "holder");
        Intrinsics.checkNotNullParameter(parameters, "parameters");
        Intrinsics.checkNotNullParameter(directive, "directive");
        if (holder instanceof List) {
            String[] stringArray;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)holder;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof Object)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            String[] it = stringArray = SequencesKt.toList(SequencesKt.map(SequencesKt.map(CollectionsKt.asSequence((List)destination$iv$iv), Directives::replicateDirective$lambda$5), arg_0 -> Directives.replicateDirective$lambda$6(directive, parameters, arg_0)));
            boolean bl = false;
            object = !((Collection)it).isEmpty() && ((List)holder).size() == it.size() ? stringArray : null;
            if (object == null) {
                stringArray = new String[]{CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
                throw new AraraException(StringExtensionsKt.formatString(LanguageController.getMessages().getERROR_VALIDATE_EMPTY_FILES_LIST(), stringArray));
            }
        } else {
            String[] stringArray = new String[]{CollectionsKt.joinToString$default(directive.getLineNumbers(), ", ", "(", ")", 0, null, null, 56, null)};
            throw new AraraException(StringExtensionsKt.formatString(LanguageController.getMessages().getERROR_VALIDATE_FILES_IS_NOT_A_LIST(), stringArray));
        }
        return object;
    }

    private final boolean checkLinePattern(Regex pattern, String line) {
        return StringsKt.isBlank(line) || pattern.containsMatchIn(line);
    }

    private static final MPPPath replicateDirective$lambda$5(Object it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new MPPPath(it.toString()).normalize();
    }

    private static final Directive replicateDirective$lambda$6(Directive $directive, Map $parameters, MPPPath reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        return hooks.getBuildDirective().invoke($directive.getIdentifier(), MapsKt.plus($parameters, TuplesKt.to("reference", reference)), $directive.getConditional(), $directive.getLineNumbers());
    }
}

