


          WEB(1)               INTERACTIVE UNIX System               WEB(1)



          NAME
               tangle, weave - translate WEB to Pascal and/or TeX

          SYNOPSIS
               ttttaaaannnngggglllleeee webfile[.web] [changefile[.ch]]
               wwwweeeeaaaavvvveeee [-x] webfile[.web] [changefile[.ch]]

          DESCRIPTION
               The _t_a_n_g_l_e program converts a WEB source document into a
               Pascal program that may be compiled in the usual way with
               the on-line Pascal compiler (e.g., ppppcccc(1)).  The output file
               is all in lower case and packed into lines of 72 characters
               or less, with the only concession to readability being the
               termination of lines at semicolons when this can be done
               conveniently.

               The WEB language allows you to prepare a single document
               containing all the information that is needed both to pro-
               duce a compilable Pascal program and to produce a well-
               formatted document describing the program in as much detail
               as the writer may desire.  The user of WEB must be familiar
               with both TeX and Pascal.  WEB also provides a relatively
               simple, although adequate, macro facility that permits a
               Pascal program to be written in small easily-understood
               modules.

               The command line should have either one or two names on it.
               The first is taken as the WEB file (and ._w_e_b is added if
               there is no extension).  If there is another name, it is a
               change file (and ._c_h is added if there is no extension).
               The change file overrides parts of the WEB file, as
               described in the WEB system documentation.

               The output files are a Pascal file and a string pool file,
               whose names are formed by adding ._p and ._p_o_o_l respectively
               to the root of the WEB file name.

               The _w_e_a_v_e program is used to create a TeX file for viewing
               the WEB program.  It takes appropriate care of typographic
               details like page layout and the use of indentation, ital-
               ics, boldface, etc., and it supplies extensive cross-index
               information that it gathers automatically.  The command line
               arguments are the same as for _t_a_n_g_l_e except for the option:
               ----xxxx says to omit the index, module name list, and table of
               contents pages.  (A _C_O_N_T_E_N_T_S._t_e_x file will still be written
               when the TeX file is processed, however, unless some macros
               in _w_e_b_m_a_c._t_e_x are redefined.)

               The output TeX file name is formed by adding ._t_e_x to the
               root of the WEB file name.

               There are several macros that probably should be redefined
               by the programmer at the beginning of the WEB file.  It is a


          Rev. 5/27/90                                               Page 1






          WEB(1)               INTERACTIVE UNIX System               WEB(1)



               good idea to set \title to the name of the program.  And, to
               cause output of only changed modules, one can say
               \let\maybe=\iffalse (usually as the first change in the
               change file).

          FILES
               /usr/local/lib/tex/inputs/webmac.tex   TeX macros used by
               weave output.

          SEE ALSO
               _T_h_e _W_E_B _S_y_s_t_e_m _o_f _S_t_r_u_c_t_u_r_e_d _D_o_c_u_m_e_n_t_a_t_i_o_n and _L_i_t_e_r_a_t_ePro-
               gramming, by D.E. Knuth.
               _W_e_a_v_i_n_ga_P_r_o_g_r_a_m, by Wayne Sewell
               tex(1), pc(1)
               pxp(1) (for formatting tangle output when debugging)
               _T_e_X: _T_h_e _P_r_o_g_r_a_m and _M_E_T_A_F_O_N_T: _T_h_e _P_r_o_g_r_a_m,_v_o_l_u_m_e_sB_a_n_dD _C_o_m_-
               _p_u_t_e_r_s _a_n_d _T_y_p_e_s_e_t_t_i_n_g series, published by Addison-Wesley,
               are by far the largest extant examples of WEB programs.

          AUTHORS
               WEB was designed by Donald E. Knuth, based on an earlier
               system called DOC (implemented by Ignacio Zabala).  The _t_a_n_-
               _g_l_e and _w_e_a_v_e programs are themselves written in WEB. The
               system was originally ported to Unix at Stanford by Howard
               Trickey, and at Cornell by Pavel Curtis.






























          Rev. 5/27/90                                               Page 2



