/* Hand-coded routines for JBibTeX in C.  */

#include "jbibd.h"

char kanji_file_code, kanji_term_code;

#define	legal_kanji_code(kcode) \
	((jis_1 <= kcode && kcode <= jis_6) || \
	 kcode == shift_jis || kcode == EUC)

initkanji()
{
    char *p;

    kanji_file_code = DEFAULT_FILE_CODE;
    kanji_term_code = DEFAULT_TERM_CODE;

    if ((p = getenv("BIBFILECODE")) != NULL)
	kanji_file_code = atoi(p);
    if (!legal_kanji_code(kanji_file_code)) {
	fprintf(stderr,
		"Kanji File Code:%d is illegal. I'll use system default\n",
		kanji_file_code);
	kanji_file_code = DEFAULT_FILE_CODE;
    }
    if ((p=getenv("BIBTERMCODE")) != NULL)
	kanji_term_code = atoi(p);
    if (!legal_kanji_code(kanji_term_code)) {
	fprintf(stderr,
		"Kanji Term Code:%d is illegal. I'll use system default\n",
		kanji_term_code);
	kanji_term_code = DEFAULT_TERM_CODE;
    }

    setinkanjitype(stdin, kanji_term_code);
    setoutkanjitype(stdout, kanji_term_code);
}

boolean
input_line(f)
FILE *f;
{
    register int i;
    register mlcinfo *mi = &mlcodeinfo[fileno(f)];

    last = 0;
    i = (*(mi->in_ln))(f, mi);
    if (i == EOF && last == 0)
	return false;
    /* We didn't get the whole line because our buffer was too small.  */
    if (i != EOF && i != '\n')
	return false;

    /* Don't bother using xord if we don't need to.  */
#ifdef NONASCII
/*
    for (i = 0; i <= last; i++)
	buffer[i] = xord[buffer[i]];
*/
#endif

    return true;
}

boolean
a_open_in(f, path_index, fopen_mode)
FILE **f;
path_constant_type path_index;
char *fopen_mode;
{
    if (open_input(f, path_index, fopen_mode)) {
	setinkanjitype(*f, kanji_file_code);
	return true;
    } else
	return false;
}

boolean
a_open_out(f, fopen_mode)
FILE **f;
char *fopen_mode;
{
    if (open_output(f, fopen_mode)) {
	setoutkanjitype(*f, kanji_file_code);
	return true;
    } else
	return false;
}
