/*
 *$Id
 *    htex.c  : a ks-to-tex converter
 *    Copyright 1992, 1993, 1994, Uhhyung Choi and Yunju Baek
 *
 *    Revision history:
 *
 *    Created by uhhyung@daiduk.kaist.ac.kr on 10-Oct-1991.
 *    Modifications by yunju@camars.kaist.ac.kr and uhhyung@cosmos.kaist.ac.kr
 *
 *    1-Mar-1994:
 *    alternative coding implemented by a7621gac@awiuni11.bitnet 
 *    (Werner Lemberg):
 *
 *    for use with hangul.sty of the hlatex2e package:
 *
 *      flag -a will enable characters in the range 14 - 30 ASCII except
 *      26 ASCII (=EOF) and 27 ASCII (=ESC) as active characters instead of
 *      range 128 - 142 ASCII. This allows the use of the extended ASCII
 *      characters found in many code pages on the PC.
 *      You must say \usepackage[altencoding]{hangul} in your document to
 *      activate the alternative encoding.
 *
 * 
 *    Comments:
 *
 *    String XCHARS is defined to allow extra space \hX for specific characters
 *    which come just before a Hangul character.
 *    Macro \hS is for similar cases except that it's for English alphabets.
 *
 *    Feel free to customize the values defined in "hfont.tex".
 *    
 *    This version supports jaso and verbatim environment.
 *
 *    This is freely distributable under the GNU public license terms.
 *
 *    Bugs:
 *    
 *    There is a known bug in line alignment in some cases.
 *    The following jaso doesn't have correct shapes.
 *
 *     ** ****       *       **       *         *        **        *        *
 *      *  **        *       **       *         *        **        *        *
 *     **  **     *  *    *  **    *  *   *******   *******  *******        *
 *     *   **   *******  ******  ******     * ***     * ***    *   *  *******
 *     ** ****       *       **       *    *    *    *   **   *    *        *
 */

#include <string.h>
#include <getopt.h>
#include <stdio.h>
#include <ctype.h>
#include "table.h"


#define XCHARS  "$()"
#define HDEL '.'


int line;

void usage()
{
        fputs("htex : KS Hangul to ASCII TeX code converter\n\n", stderr);
        fputs("Usage: htex [-a] inputfile|- [outputfile]\n",stderr);
}

int Fgetc(in)
FILE *in;
{
        int c;
        c = fgetc(in);
        if (c=='\n') line++;
        return c;
}

void main(argc,argv)
int argc;
char **argv;
{
        FILE *in,*out;
        extern unsigned char htbl[][4];
        int opt, ch=0, last=0, font=0, chead;

        char BSC=0200;          /* default encoding */
        char SHA1=0201, SHA2=0202, SHA3=0203;
        char SHB1=0204, SHB2=0205, SHB3=0206;
        char HEND=0207;
        char SHX=0210;
        char PENALTY_OFFSET=8;

        while ((opt=getopt(argc,argv,"a"))!=-1) {
                if (opt=='a' || opt=='A') {  /* alternative encoding */
                        BSC=17;
                        SHA1=14; SHA2=15; SHA3=16;
                        SHB1=19; SHB2=20; SHB3=21;
                        HEND=18;
                        SHX=22;
                        PENALTY_OFFSET=9;
                } else {
                        usage();
                        exit(0);
                }
        }
        if (argc==optind || argc-optind>2) {
                usage();
                exit(0);
        }
        in = strcmp(argv[optind],"-") ? fopen(argv[optind],"r"): stdin;
        out = argc==optind+2 ? fopen(argv[optind+1],"w") : stdout;
        if (in==NULL) {
                printf("%s : not found\n",argv[optind]);
                exit(0);
        }
        if (out==NULL) {
                printf("%s : not found\n",argv[optind+1]);
                exit(0);
        }
        line=1;
        ch = Fgetc(in);
        while (!feof(in)) {
                if (ch>160) {
                        int code,code2;
                        code = 94*(ch-176);
                        code2 = Fgetc(in);
                        if (code2<=160){
                                fprintf(stderr,"bad char in line %d\n",line);
                                ch = Fgetc(in);
                                continue;
                        }
                        code += (code2-161);
                        if (ch==0xa4) {
                                code = 2350+code2-161;
                        } else if (code<0||code>2349) {
                                fprintf(stderr,"bad char in line %d\n",line);
                                ch = Fgetc(in);
                                continue;
                        }
                        if (isalpha(last)) fprintf(out,"%c%c",BSC,SHX);
                        if (strchr(XCHARS,last)) fprintf(out,"%c%c",BSC,SHX);

                        font = htbl[code][0];
                        if (font==1) chead = SHA1; /* hA */
                        else chead = SHB1; /* hB */
                        last = ch; ch = Fgetc(in);
                        if (ch>160) chead+=PENALTY_OFFSET;
                        if (htbl[code][3]) {
                                fprintf(out,"%c%c%c%X%c%X%c%X",
                                        BSC,chead+2,HDEL,htbl[code][1],HDEL,htbl[code][2],
                                        HDEL,htbl[code][3]);
                        } else if (htbl[code][2]) {
                                if (htbl[code][2]==32) {
                                        fprintf(out,"%c%c%c%X",
                                                BSC,chead,HDEL,htbl[code][1]);
                                        fprintf(out,"\\kern 1em");
                                } else {
                                        fprintf(out,"%c%c%c%X%c%X",
                                                BSC,chead+1,HDEL,htbl[code][1],
                                                HDEL,htbl[code][2]);
                                }
                        } else {
                                fprintf(out,"%c%c%c%X",
                                BSC,chead,HDEL,htbl[code][1]);
                        }
                        fprintf(out,"%c",HEND);
                } else {
                        putc(ch,out);
                        last = ch;
                        ch = Fgetc(in);
                }
        }
        fclose(in);
        fclose(out);
}

