# -*- python -*-
# $Id: match.py,v 1.3 2000/11/21 22:38:43 yotam Exp $
import re;
import string;
from lsp import ListPath;

# For each font we have 1 tfm and a list of pk's for some resolutions.
class Matcher:
   def __init__(self, tfmPath, pkPath):
      tfmLP = ListPath(tfmPath);
      pkLP = ListPath(pkPath);
      self.fonts = {}
      pkpat = re.compile("^([^\.]+)\.([0-9]+)pk$");
      for (pkBase, pkFull) in pkLP.base2full.items():
         match = pkpat.match(pkBase);
         if match:
            fontname = match.group(1);
            fonttfm = fontname + ".tfm";
            if tfmLP.base2full.has_key(fonttfm):
               if not self.fonts.has_key(fontname):
                  self.fonts[fontname] = (tfmLP.base2full[fonttfm], {});
               res = match.group(2);
               self.fonts[fontname][1][res] = pkFull;


#
if __name__ == '__main__':
   import sys;
   tfmpath = sys.argv[1];
   pkpath = sys.argv[2];
   print "tfmpath=%s, pkpath=%s" % (tfmpath, pkpath);
   matcher = Matcher(tfmpath, pkpath);
   for key in matcher.fonts.keys():
      print "key=", key
