% philips.ch -*-mode: change; webfile: crudetype.web version 3.01;-*-
% PHILIPS. Change file for Philips printer
% NOTE the system change file must normally be inserted above this point.
% This file became obsolete when its printer was removed.
%


@x  Module 235; Lines 4028 -- 4028
*** Attach printer change file here ***
@y

This is a change file for a particular model of Philips, with a particular set
of resident fonts. It cannot be assumed that this file will work on other
Philipses, or on the same model with a different operating system. I have
tried to adapt this to \.{Crudetype} version 2, but I have no way to test it.

@<Const...@>= device_ID = 'Philips';

@ Where will the printed file go to?

@<Set init...@>=
  be_string( '.PHI' ) ;  print_ex := buffer ;

@ The first batch of constants describes the printer's style of carriage
control. |fortran| means that the carriage control character gets put at the
start of the line, and it is here assumed that it must be inserted explicitly.
Note also that the program makes no attempt to check all these values for
consistency.

@<Carriage control constants@>=
  fortran = false ;
  list = false ;
  b_feed_absolute = false ;
  b_feed_by_string = false ;
  feed_absolute = true ;
  b_feed_scream = true ;
  b_space_absolute = true ;
  b_space_by_string =false ;
  space_absolute = true ;
  abs_is_incr = false ;
  w_l_does_c_r = false ;
  want_split = true ;
  is_header = false ; {each page needs a header}
  param_type = 'D' ;

@ This batch is concerned with distances and resolutions.

@<Const...@>=
  l_margin = 10 ;
  top_margin = 24 ;
  h_resolution = 72 ;         {h_steps per inch}
  v_resolution = 48 ;         {v_steps per inch}
  fixed_width = true ;        {printer's characters are fixed width}
  h_fudge = 1.4 ;
    {Trial and error. May need to be adjusted}
  v_fudge = 1 ;
  char_width = 6 ;
      {all printer characters are this width, in units of |h_step|. Normally,
          space_dist will be equal to this, but some printers are not normal!}
  gap_width = 2 ; {Intended minimum space between words}
  char_ht = 8 ;

@ Next, some constants for rule-setting.

@<Rule setting const...@>=
  rail_width = 6 ;  {Height and width of rule chars, in steps}
  rail_height  = 1 ;
  post_width = 1 ;
  post_height = 6 ;
  rail_types = 1 ;

@ @<Set rule characters@>=
  rail_chars[1] := codes[ 1, 95 ] ;
  post_char := codes[ 1, 124] ;

@ @<Pause constants...@>=
  do_pause = false ;
  pause_steps = 20 ;
  pause_ask = 'PAUSED. Type <return> to continue' ;

@ The next batch are concerned with the printers fonts.

@<Const...@>=
  min_font = 1 ;
  {smallest & largest number of printers resident fonts}
  max_font = 5 ;
  only_one_font = false ;
  can_dl_font = false ;
  min_dl_font = 0 ;
  max_dl_font = 0 ; {printers down-loadable fonts}
  max_codes = 8 ; {no. of known \TeX\ coding schemes}
  max_char = 127 ;  {max. no. of chars per \TeX\ font}
  max_plain = 4 ;  {Max number of a plain text font}

@ Finally, consider command strings. These are intended to set various
options. In the |start_stuff| below, each `^[' will be translated into ASCII
escape. Taking these escape sequences in order, they: select portrait paper,
clear all tabs and margin, select initial font and pitch, set step size |1/6|
character pitch  (that was why we had to select a font), and set line spacing
at 48 per inch .

@<Set init...@>=
  be_string ( '^[[22h^[[3g^[[2;2x^[;^[[4y^[[48{ ' ) ;
  start_stuff := buffer ;
  be_string ( '^[[&D;2x' ) ;  font_command := buffer ;
  be_string ( '^[[&Dd' ) ;   v_abs_command := buffer ;
  be_string ('^[[&D`' ) ;    h_abs_command := buffer ;
  stop_stuff := blank ;
  page_top  := blank ;
  pause_after := blank ;

@* Character code data for the printer.

Here we actually put data into the |codes| array. In general, I have merely
replaced each character in the PLAIN.TEX coding schemes by the nearest equiv-
alent in ASCII, when any reasonable equivalent exists ; I have not tried to
tackle either AMSY or AMATHEX ; clearly there will be some scope for doing so.
First we give the scheme names, ( padded to |code_len|) then do stuff for each
name in turn. On the Philips ( as set up here) there are essentially 2 useful
fonts ; 2 is a Roman font, 5 is a simple math symbol font.

@<Assign char...@>=
   be_string( ' ' ) ; set_scheme( 0 ) ;
   be_string( 'TEX EXTENDED ASCII' ) ; set_scheme( 1 ) ;
   be_string( 'TEX TYPEWRITER TEXT' ) ; set_scheme( 2 ) ;
   be_string( 'TEX TEXT' ) ; set_scheme( 3 ) ;
   be_string( 'TEX TEXT WITHOUT F-LIGATURES' ) ; set_scheme( 4 ) ;
   be_string( 'AEFMNOT ONLY' ) ; set_scheme( 5 ) ;
   be_string( 'TEX MATH ITALIC' ) ; set_scheme( 6 ) ;
   be_string( 'TEX MATH SYMBOLS' ) ; set_scheme( 7 ) ;
   be_string( 'TEX MATH EXTENSION' ) ; set_scheme( 8 ) ;

@ Now do scheme 1 = EXTENDED ASCII

@<Assign char...@>=
  alphabet( 32, 95, 1, 2, 32) ;
  be_string(  ' o       &       a       b       LL      ~       e       p           ') ;
  row( 1,0,5) ;
  be_string(  ' l       g       d       ^       #       {LQ|}   LT      LB          ') ;
  row( 1,1,5) ;
  be_string(  ' Z       Z       Z       Z       Z       Z       `       \           ') ;
  row( 1,2,5) ;
  be_string(  ' :       ;       ?       Z       LM      LN      LI      [F2or]      ') ;
  row( 1,3,5) ;
  codes[1,127].IM_font :=  2 ;
  codes[1,127].IM_char :=  "Z" ;

@ Now do scheme 2 = TYPEWRITER. Unfortunately, \.TANGLE imposes a limit of 69
on the length of quoted strings. This causes difficulty because several multi-
character commands are too long for 8 of them to fit neatly into a string of
that length. So I use the Z command to ( effectively) split any complicated
|row_spec| into two.

@<Assign char...@>=
  alphabet( 32, 95, 2, 2, 32) ;
  codes[2, 127].IM_char := 34 ;
  be_string(  ' LG      LD      LQ      LL      LI      LP      LS      LU          ') ;
  row( 2,0,5) ;
  be_string(  ' LF      LY      LW      ^       &       F2Q     !       ?           ') ;
  row( 1,1,5) ;
  be_string(  ' i       j       `       Q       Z       Z       <U_>    <U.>        ') ;
  row( 2,2,2) ;
  be_string(  ' ,       {LB_}   [aK3e]  [oK3e] {o/}    [LAK3LE] [LOK3LE] {LO/}      ') ;
  row( 2,3,2) ;


@ The TEX TEXT scheme is nearly the same, so we start by copying it.

@<Assign char...@>=
  for in_i := 0 to 127 do codes [3, in_i] := codes [2, in_i] ;
  be_string(  ' Z       Z       Z       [ff]    [fi]    [fl]    [ffi]   [ffl]       ') ;
  row( 3,1,2) ;
  be_string(  ' Z       Z       Z       Z       !       Z       ?       Z           ') ;
  row( 3,7,2) ;
  be_string(  ' Z       Z       Z       Z       W       Z       Z       <U.>        ') ;
  row( 3,11,2) ;
  be_string(  ' Z       Z       Z       -       [--]    W       ~       W           ') ;
  row( 3,15,2) ;

@ Recently there has appeared a scheme, called TEX TEXT WITHOUT F-LIGATURES.

@<Assign char...@>=
  for in_i := 0 to 127 do codes [4, in_i] := codes [3, in_i] ;
  be_string(  ' {oI}    {u|}    Z       {^|}    {v|}    Q       !       ?           ') ;
  row( 4,1,2) ;

@ and AEFMNOT ONLY  (for the Metafont logo).

@<Assign char...@>=
  be_string(  ' Z      LA       Z       Z       Z      LE      LF       Z           ') ;
  row( 5,8,2) ;
  be_string(  ' Z       Z       Z       Z       Z      LM      LN      LO           ') ;
  row( 5,9,2) ;
  be_string(  ' Z       Z       Z       Z      LT       Z       Z       Z           ') ;
  row( 5,10,2) ;

@ Now the MATH ITALIC scheme. The Philips can try to do quite a lot of this.
As before, a lot of this is indistinguishable from the TEXT scheme, so we copy

@<Assign char...@>=
  for in_i := 0 to 10 do codes [6, in_i] := codes [2, in_i] ;
  for in_i := 48 to 122 do codes [6, in_i] := codes [2, in_i] ;
  {Next the lower-case Greek letters in rows 1..4}
  be_string(  ' Z       Z       Z       a       b       g       d       e           ') ;
  row( 6,1,5) ;
  be_string(  ' z       h       q       j       k       l       m       n           ') ;
  row( 6,2,5) ;
  be_string(  ' c       p       r       s       t       n       f       x           ') ;
  row( 6,3,5) ;
  be_string(  ' y       w       e       q       w       r       z       f           ') ;
  row( 6,4,5) ;
  be_string(  ' [:-]    [:-]    [-;]    [-;]    Z       Z       Z       Z           ') ;
  row( 6,5,5) ;
  be_string(  ' Z       Z       .       ,       Z       /       Z       *           ') ;
  row( 6,7,2) ;
  be_string(  ' Z       Z       Z       i       j       p       <UF5;>  Z           ') ;
  row( 6,15,2) ;

@ MATH SYMBOLS are messy, and no doubt the results will look unpleasant.

@<Assign char...@>=
  alphabet( 65, 26, 7, 1, 65) ;
  be_string(  ' -       .       {\/}    *       {-:}    Z       {+_}    <U_+>       ') ;
  row( 7,0,2) ;
  be_string(  ' {LO+}   {LO-}   {LOx}   {LO/}   LO      LO       o       o          ') ;
  row( 7,1,2) ;
  be_string(  ' Z       {=_}    Z       Z       {L<_}   {L>_}   {L<_}   {L>_}       ') ;
  row( 7,2,2) ;
  be_string(  ' ~       <U~~>   Z       Z       [L<L<]  [L>L>]  L<      L>          ') ;
  row( 7,3,2) ;
  be_string(  ' [{L<-}-]        [{L>-}-]        {|^}            {|v}    Z Z Z Z     ') ;
  row( 7,4,2) ;
  be_string(  ' Z Z Z Z         [{L<-}{-L>}]    /               \       {~_}        ') ;
  row( 7,4,2) ;
  be_string(  ' [{L<=}=]        [{L>=}=]        Z               Z       Z Z Z Z     ') ;
  row( 7,5,2) ;
  be_string(  ' Z Z Z Z         [{L<=}{=L>}]    Z               Z       Z           ') ;
  row( 7,5,2) ;
  be_string(  ' Q               [oo]            {L(-}           {-L)}   Z Z Z Z     ') ;
  row( 7,6,2) ;
  be_string(  ' Z Z Z Z         [{/_}{_\}]      <U[__][\/]>     /       Q           ') ;
  row( 7,6,2) ;
  be_string(  ' [{\-}{-/}]      <U_[{-_}|]>     ~       {0/}    LR LT   <U_|>   {|_}') ;
  row( 7,7,2) ;
  be_string(  ' Z       Z       Z       LU      Z       {LU+}   &       [or]        ') ;
  row( 7,11,2) ;
  be_string(  ' [{|-}-]         [-{-|}]         Z Z Z   Z       L{      L}          ') ;
  row( 7,12,2) ;
  be_string(  ' L<      L>      |       [||]    {^|v}   {^|v}   \       Z           ') ;
  row( 7,13,2) ;
  be_string(  ' <Z{-v/}>        [{I_}{_I}]      <U[__][\/]>     Z       Z Z Z Z     ') ;
  row( 7,14,2) ;

@<Set rule characters@>

@z
