.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.03",
.\"     date            = "19 February 1999",
.\"     time            = "12:31:28 MST",
.\"     filename        = "citefind.man",
.\"     address         = "Center for Scientific Computing
.\"                        University of Utah
.\"                        Department of Mathematics, 322 INSCC
.\"                        155 S 1400 E RM 233
.\"                        Salt Lake City, UT 84112-0090
.\"                        USA
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 585 1640, +1 801 581 4148",
.\"     URL             = "http://www.math.utah.edu/~beebe",
.\"     checksum        = "34902 169 737 5857",
.\"     email           = "beebe@math.utah.edu, beebe@acm.org,
.\"                        beebe@ieee.org (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, citation label,
.\"                        citation tag",
.\"     supported       = "yes",
.\"     docstring       = "This file contains the UNIX manual pages
.\"                        for the citefind command, a shell script
.\"                        that invokes an awk program to extract from
.\"                        a list of BibTeX .bib files bibliography
.\"                        entries that match a specified list of
.\"                        citation tags, possibly produced by
.\"                        citetags(1).
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\" ====================================================================
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.TH CITEFIND 1 "19 February 1999" "Version 1.03"
.\"======================================================================
.SH NAME
citefind \- extract matching bibliography entries from BibTeX .bib files
.\"======================================================================
.SH SYNOPSIS
.nf
.BI citefind " tags-file bibfile(s) >newbibfile"
.fi
or
.nf
.BI citefind " \- bibfile(s) >newbibfile"
.fi
.\"======================================================================
.SH DESCRIPTION
.B citefind
extracts from a list of \*(Bi\&
.I .bib
files those bibliography entries that match a
specified list of citation tags, possibly produced
by
.BR citetags (1),
sending the entries to
.IR stdout ,
together with all \*(Bi\& ``@Preamble{.\|.\|.}''
and ``@String{.\|.\|.}'' commands.
.PP
If the first argument,
.IR tags-file ,
is ``\-'', the tag list is read from
.IR stdin ,
allowing it to be piped from
.BR citetags (1).
.PP
Bibliography entries are output in the order found
in the
.I .bib
files.  In the absence of cross references, you
may be able to use
.BR bibsort (1)
to sort them by citation key.  While such sorting
is unnecessary for \*(Bi\& itself, it is
convenient for a human reader of the
.I .bib
file.
.PP
When documents are prepared using a large
bibliography data base collection, it is sometimes
convenient to extract a subset \*(Bi\&
bibliography file incorporating only those entries
that are cited in the document.  A good example is
a document to be submitted to a publisher, or
otherwise distributed in electronic form.
.PP
.B citefind
expects the bibliography file(s) to be consistently
formatted in the style produced by
.BR bibclean (1),
which allows use of simple pattern matching to recognize the required
entries.
.PP
To guard against match failures, from version 1.03,
.B citefind
will complain if requested entries are not found at all, or are found
(and output) more than once.  It will also complain if end-of-file is
reached during collection of any bibliography entry.
.\"======================================================================
.SH "BUGS"
.B citefind
is not smart enough to incorporate \*(Bi\&
cross references unless their citation tags are
included in the input list.
.PP
No attempt is made to reduce the output
``@String{.\|.\|.}'' commands to just those that
are actually referenced.
.PP
Those features should be added.
.\"======================================================================
.SH "SEE ALSO"
.BR bibcheck (1),
.BR bibclean (1),
.BR bibdup (1),
.BR bibextract (1),
.BR bibjoin (1),
.BR biblabel (1),
.BR biblex (1),
.BR biborder (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR citesub (1),
.BR citetags (1),
.BR gawk (1),
.BR latex (1),
.BR nawk (1),
.BR tex (1).
.\"======================================================================
.SH FILES
.\" NB: LIBDIR and BINDIR are substituted for real directory names
.\"     by a sed script invoked by "make install".
.TP \w'@LIBDIR@/citefind.awk'u+2n
@LIBDIR@/citefind.awk
.BR nawk (1)
program for tag extraction.
.TP
@BINDIR@/citefind
user-callable shell script to invoke
.BR nawk (1).
.\"======================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 322 INSCC
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Tel: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
Email: beebe@math.utah.edu, beebe@acm.org, beebe@ieee.org (Internet)
WWW: http://www.math.utah.edu/~beebe
.fi
.\"==============================[The End]==============================
